/*
 * Decompiled with CFR 0.152.
 */
package org.apache.vysper.xmpp.server;

import java.util.HashMap;
import java.util.Map;
import org.apache.vysper.xmpp.addressing.Entity;
import org.apache.vysper.xmpp.protocol.ProtocolException;
import org.apache.vysper.xmpp.protocol.SessionStateHolder;
import org.apache.vysper.xmpp.protocol.StanzaHandler;
import org.apache.vysper.xmpp.server.ServerRuntimeContext;
import org.apache.vysper.xmpp.server.SessionContext;
import org.apache.vysper.xmpp.server.SessionState;
import org.apache.vysper.xmpp.stanza.Stanza;
import org.apache.vysper.xmpp.stanza.StanzaBuilder;
import org.apache.vysper.xmpp.state.resourcebinding.BindException;
import org.apache.vysper.xmpp.uuid.JVMBuiltinUUIDGenerator;
import org.apache.vysper.xmpp.uuid.UUIDGenerator;
import org.apache.vysper.xmpp.writer.StanzaWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSessionContext
implements SessionContext {
    private static final Logger logger = LoggerFactory.getLogger(AbstractSessionContext.class);
    protected ServerRuntimeContext serverRuntimeContext;
    protected String sessionId;
    protected String xmlLang;
    protected UUIDGenerator sequence = new JVMBuiltinUUIDGenerator();
    protected SessionStateHolder sessionStateHolder;
    protected Entity serverEntity;
    private Entity initiatingEntity;
    private boolean serverToServer = false;
    private Map<String, Object> attributeMap = new HashMap<String, Object>();

    public AbstractSessionContext(ServerRuntimeContext serverRuntimeContext, SessionStateHolder sessionStateHolder) {
        this.serverRuntimeContext = serverRuntimeContext;
        this.sessionId = serverRuntimeContext.getNextSessionId();
        this.serverEntity = serverRuntimeContext.getServerEnitity();
        this.xmlLang = serverRuntimeContext.getDefaultXMLLang();
        this.sessionStateHolder = sessionStateHolder;
    }

    public String toString() {
        return this.sessionId;
    }

    public ServerRuntimeContext getServerRuntimeContext() {
        return this.serverRuntimeContext;
    }

    public boolean isRemotelyInitiatedSession() {
        return true;
    }

    public Entity getInitiatingEntity() {
        return this.initiatingEntity;
    }

    public void setInitiatingEntity(Entity entity) {
        if (entity == null) {
            throw new IllegalArgumentException("initiating entity must not be set to NULL");
        }
        if (entity.isResourceSet()) {
            throw new IllegalArgumentException("initiating entity must be bare JID");
        }
        this.initiatingEntity = entity;
    }

    public boolean isServerToServer() {
        return this.serverToServer;
    }

    public void setServerToServer() {
        this.serverToServer = true;
    }

    public void setClientToServer() {
        this.serverToServer = false;
    }

    public SessionState getState() {
        return this.sessionStateHolder.getState();
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public void setSessionId(String sessionId) {
        this.sessionId = sessionId;
    }

    public String getXMLLang() {
        return this.xmlLang;
    }

    public void setXMLLang(String languageCode) {
        this.xmlLang = languageCode;
    }

    public void endSession(SessionContext.SessionTerminationCause terminationCause) {
        StanzaWriter stanzaWriter = this.getResponseWriter();
        stanzaWriter.close();
        if (terminationCause == null) {
            throw new RuntimeException("no termination cause given");
        }
        if (terminationCause == SessionContext.SessionTerminationCause.CLIENT_BYEBYE || terminationCause == SessionContext.SessionTerminationCause.CONNECTION_ABORT) {
            if (this.getState().equals((Object)SessionState.AUTHENTICATED)) {
                Stanza unavailableStanza = StanzaBuilder.createUnavailablePresenceStanza(null, terminationCause);
                StanzaHandler handler = this.serverRuntimeContext.getHandler(unavailableStanza);
                try {
                    handler.execute(unavailableStanza, this.serverRuntimeContext, true, this, this.sessionStateHolder);
                }
                catch (ProtocolException e) {
                    logger.error("Failed to send unavailable stanza on connection close", (Throwable)e);
                }
            }
        } else if (terminationCause != SessionContext.SessionTerminationCause.SERVER_SHUTDOWN && terminationCause != SessionContext.SessionTerminationCause.STREAM_ERROR) {
            throw new IllegalArgumentException("endSession() not implemented for termination cause");
        }
        this.serverRuntimeContext.getResourceRegistry().unbindSession(this);
        this.sessionStateHolder.setState(SessionState.CLOSED);
    }

    public Entity getServerJID() {
        return this.serverEntity;
    }

    public String bindResource() throws BindException {
        return this.getServerRuntimeContext().getResourceRegistry().bindSession(this);
    }

    public String nextSequenceValue() {
        return this.sequence.create();
    }

    public Object putAttribute(String key, Object value) {
        return this.attributeMap.put(key, value);
    }

    public Object getAttribute(String key) {
        return this.attributeMap.get(key);
    }
}

