/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.usermodel;

import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;

public class HSSFDateUtil {
    private static final int BAD_DATE = -1;
    private static final long DAY_MILLISECONDS = 86400000L;

    private HSSFDateUtil() {
    }

    public static double getExcelDate(Date date) {
        return HSSFDateUtil.getExcelDate(date, false);
    }

    public static double getExcelDate(Date date, boolean use1904windowing) {
        Calendar calStart = new GregorianCalendar();
        calStart.setTime(date);
        if (!use1904windowing && calStart.get(1) < 1900 || use1904windowing && calStart.get(1) < 1904) {
            return -1.0;
        }
        double fraction = (double)(((calStart.get(11) * 60 + calStart.get(12)) * 60 + calStart.get(13)) * 1000 + calStart.get(14)) / 8.64E7;
        calStart = HSSFDateUtil.dayStart(calStart);
        double value = fraction + (double)HSSFDateUtil.absoluteDay(calStart, use1904windowing);
        if (!use1904windowing && value >= 60.0) {
            value += 1.0;
        } else if (use1904windowing) {
            value -= 1.0;
        }
        return value;
    }

    public static Date getJavaDate(double date) {
        return HSSFDateUtil.getJavaDate(date, false);
    }

    public static Date getJavaDate(double date, boolean use1904windowing) {
        if (HSSFDateUtil.isValidExcelDate(date)) {
            int startYear = 1900;
            int dayAdjust = -1;
            int wholeDays = (int)Math.floor(date);
            if (use1904windowing) {
                startYear = 1904;
                dayAdjust = 1;
            } else if (wholeDays < 61) {
                dayAdjust = 0;
            }
            GregorianCalendar calendar = new GregorianCalendar(startYear, 0, wholeDays + dayAdjust);
            int millisecondsInDay = (int)((date - Math.floor(date)) * 8.64E7 + 0.5);
            calendar.set(14, millisecondsInDay);
            return calendar.getTime();
        }
        return null;
    }

    public static boolean isADateFormat(int formatIndex, String formatString) {
        if (HSSFDateUtil.isInternalDateFormat(formatIndex)) {
            return true;
        }
        if (formatString == null || formatString.length() == 0) {
            return false;
        }
        String fs = formatString;
        fs = fs.replaceAll("\\\\-", "-");
        fs = fs.replaceAll("\\\\,", ",");
        fs = fs.replaceAll("\\\\ ", " ");
        fs = fs.replaceAll(";@", "");
        return (fs = fs.replaceAll("\\[\\$\\-.*?\\]", "")).matches("^[ymd\\-/, ]+$");
    }

    public static boolean isInternalDateFormat(int format) {
        boolean retval = false;
        switch (format) {
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 45: 
            case 46: 
            case 47: {
                retval = true;
                break;
            }
            default: {
                retval = false;
            }
        }
        return retval;
    }

    public static boolean isCellDateFormatted(HSSFCell cell) {
        if (cell == null) {
            return false;
        }
        boolean bDate = false;
        double d = cell.getNumericCellValue();
        if (HSSFDateUtil.isValidExcelDate(d)) {
            HSSFCellStyle style = cell.getCellStyle();
            short i = style.getDataFormat();
            String f = style.getDataFormatString(cell.getBoundWorkbook());
            bDate = HSSFDateUtil.isADateFormat(i, f);
        }
        return bDate;
    }

    public static boolean isCellInternalDateFormatted(HSSFCell cell) {
        if (cell == null) {
            return false;
        }
        boolean bDate = false;
        double d = cell.getNumericCellValue();
        if (HSSFDateUtil.isValidExcelDate(d)) {
            HSSFCellStyle style = cell.getCellStyle();
            short i = style.getDataFormat();
            bDate = HSSFDateUtil.isInternalDateFormat(i);
        }
        return bDate;
    }

    public static boolean isValidExcelDate(double value) {
        return value > -4.9E-324;
    }

    static int absoluteDay(Calendar cal, boolean use1904windowing) {
        return cal.get(6) + HSSFDateUtil.daysInPriorYears(cal.get(1), use1904windowing);
    }

    private static int daysInPriorYears(int yr, boolean use1904windowing) {
        if (!use1904windowing && yr < 1900 || use1904windowing && yr < 1900) {
            throw new IllegalArgumentException("'year' must be 1900 or greater");
        }
        int yr1 = yr - 1;
        int leapDays = yr1 / 4 - yr1 / 100 + yr1 / 400 - 460;
        return 365 * (yr - (use1904windowing ? 1904 : 1900)) + leapDays;
    }

    private static Calendar dayStart(Calendar cal) {
        cal.get(11);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        cal.get(11);
        return cal;
    }
}

