/*
 * Decompiled with CFR 0.152.
 */
package org.pdfbox.examples.pdmodel;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.pdfbox.pdmodel.PDDocument;
import org.pdfbox.pdmodel.PDPage;
import org.pdfbox.pdmodel.common.PDRectangle;
import org.pdfbox.pdmodel.interactive.annotation.PDAnnotationRubberStamp;

public class RubberStamp {
    private RubberStamp() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        if (args.length != 2) {
            RubberStamp.usage();
        } else {
            PDDocument document = null;
            try {
                document = PDDocument.load(args[0]);
                if (document.isEncrypted()) {
                    throw new IOException("Encrypted documents are not supported for this example");
                }
                ArrayList allpages = new ArrayList();
                document.getDocumentCatalog().getPages().getAllKids(allpages);
                for (int i = 0; i < allpages.size(); ++i) {
                    PDPage apage = (PDPage)allpages.get(i);
                    List annotations = apage.getAnnotations();
                    PDAnnotationRubberStamp rs = new PDAnnotationRubberStamp();
                    rs.setName("TopSecret");
                    rs.setRectangle(new PDRectangle(100.0f, 100.0f));
                    rs.setContents("A top secret note");
                    annotations.add(rs);
                }
                document.save(args[1]);
            }
            finally {
                if (document != null) {
                    document.close();
                }
            }
        }
    }

    private static void usage() {
        System.err.println("Usage: java org.pdfbox.examples.pdmodel.RubberStamp <input-pdf> <output-pdf>");
    }
}

