/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.registry.extension.repo;

import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.util.Comparator;
import java.util.Objects;
import org.apache.nifi.registry.link.LinkableEntity;

@XmlRootElement
public class ExtensionRepoArtifact
extends LinkableEntity
implements Comparable<ExtensionRepoArtifact> {
    private String bucketName;
    private String groupId;
    private String artifactId;

    @Schema(description="The bucket name")
    public String getBucketName() {
        return this.bucketName;
    }

    public void setBucketName(String bucketName) {
        this.bucketName = bucketName;
    }

    @Schema(description="The group id")
    public String getGroupId() {
        return this.groupId;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    @Schema(description="The artifact id")
    public String getArtifactId() {
        return this.artifactId;
    }

    public void setArtifactId(String artifactId) {
        this.artifactId = artifactId;
    }

    @Override
    public int compareTo(ExtensionRepoArtifact o) {
        return Comparator.comparing(ExtensionRepoArtifact::getArtifactId).thenComparing(ExtensionRepoArtifact::getGroupId).thenComparing(ExtensionRepoArtifact::getBucketName).compare(this, o);
    }

    public int hashCode() {
        return Objects.hash(this.bucketName, this.groupId, this.artifactId);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ExtensionRepoArtifact other = (ExtensionRepoArtifact)obj;
        return Objects.equals(this.getBucketName(), other.getBucketName()) && Objects.equals(this.getGroupId(), other.getGroupId()) && Objects.equals(this.getArtifactId(), other.getArtifactId());
    }
}

