/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.controller.queue;

import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.nifi.controller.queue.DropFlowFileStatus;
import org.apache.nifi.controller.queue.ListFlowFileStatus;
import org.apache.nifi.controller.queue.LoadBalanceCompression;
import org.apache.nifi.controller.queue.LoadBalanceStrategy;
import org.apache.nifi.controller.queue.PollStrategy;
import org.apache.nifi.controller.queue.QueueDiagnostics;
import org.apache.nifi.controller.queue.QueueSize;
import org.apache.nifi.controller.repository.FlowFileRecord;
import org.apache.nifi.controller.repository.SwapSummary;
import org.apache.nifi.controller.status.FlowFileAvailability;
import org.apache.nifi.flowfile.FlowFilePrioritizer;
import org.apache.nifi.processor.FlowFileFilter;

public interface FlowFileQueue {
    public String getIdentifier();

    public List<FlowFilePrioritizer> getPriorities();

    public SwapSummary recoverSwappedFlowFiles();

    public void purgeSwapFiles();

    public void setPriorities(List<FlowFilePrioritizer> var1);

    public void setBackPressureObjectThreshold(long var1);

    public long getBackPressureObjectThreshold();

    public void setBackPressureDataSizeThreshold(String var1);

    public String getBackPressureDataSizeThreshold();

    public QueueSize size();

    public long getTotalQueuedDuration(long var1);

    public long getMinLastQueueDate();

    public boolean isEmpty();

    public FlowFileAvailability getFlowFileAvailability();

    public boolean isActiveQueueEmpty();

    public void acknowledge(FlowFileRecord var1);

    public void acknowledge(Collection<FlowFileRecord> var1);

    public boolean isUnacknowledgedFlowFile();

    public boolean isFull();

    public void put(FlowFileRecord var1);

    public void putAll(Collection<FlowFileRecord> var1);

    public FlowFileRecord poll(Set<FlowFileRecord> var1, PollStrategy var2);

    public FlowFileRecord poll(Set<FlowFileRecord> var1);

    public List<FlowFileRecord> poll(int var1, Set<FlowFileRecord> var2, PollStrategy var3);

    public List<FlowFileRecord> poll(int var1, Set<FlowFileRecord> var2);

    public List<FlowFileRecord> poll(FlowFileFilter var1, Set<FlowFileRecord> var2, PollStrategy var3);

    public List<FlowFileRecord> poll(FlowFileFilter var1, Set<FlowFileRecord> var2);

    public String getFlowFileExpiration();

    public long getFlowFileExpiration(TimeUnit var1);

    public void setFlowFileExpiration(String var1);

    public DropFlowFileStatus dropFlowFiles(String var1, String var2);

    public DropFlowFileStatus getDropFlowFileStatus(String var1);

    public DropFlowFileStatus cancelDropFlowFileRequest(String var1);

    public ListFlowFileStatus listFlowFiles(String var1, int var2);

    public ListFlowFileStatus getListFlowFileStatus(String var1);

    public ListFlowFileStatus cancelListFlowFileRequest(String var1);

    public FlowFileRecord getFlowFile(String var1) throws IOException;

    public void verifyCanList() throws IllegalStateException;

    public QueueDiagnostics getQueueDiagnostics();

    public void lock();

    public void unlock();

    public void setLoadBalanceStrategy(LoadBalanceStrategy var1, String var2);

    public void offloadQueue();

    public void resetOffloadedQueue();

    public LoadBalanceStrategy getLoadBalanceStrategy();

    public void setLoadBalanceCompression(LoadBalanceCompression var1);

    public LoadBalanceCompression getLoadBalanceCompression();

    public String getPartitioningAttribute();

    public void startLoadBalancing();

    public void stopLoadBalancing();

    public boolean isActivelyLoadBalancing();
}

