/*
 * Decompiled with CFR 0.152.
 */
package de.vandermeer.asciithemes;

import de.vandermeer.asciithemes.IsTextArt;
import de.vandermeer.asciithemes.TA_GridHelpers;
import de.vandermeer.asciithemes.TA_GridThemeOptions;
import de.vandermeer.asciithemes.TA_GridThemes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.text.StrBuilder;
import org.apache.commons.lang3.tuple.Pair;

public interface TA_Grid
extends IsTextArt {
    public Map<Integer, Character> getCharacterMap();

    default public TA_Grid addCharacterMap(int ruleset, char none, char horizontal, char vertical, char topleft, char topright, char bottomleft, char bottomright, char midleft, char midright, char midboth, char middown, char midup) {
        Map<Integer, Character> map = this.getCharacterMap();
        Validate.notNull(map);
        Validate.noNullElements(map.keySet());
        Validate.noNullElements(map.values());
        map.put(0 + ruleset, Character.valueOf(none));
        map.put(12 + ruleset, Character.valueOf(horizontal));
        map.put(3 + ruleset, Character.valueOf(vertical));
        map.put(10 + ruleset, Character.valueOf(topleft));
        map.put(6 + ruleset, Character.valueOf(topright));
        map.put(9 + ruleset, Character.valueOf(bottomleft));
        map.put(5 + ruleset, Character.valueOf(bottomright));
        map.put(11 + ruleset, Character.valueOf(midleft));
        map.put(7 + ruleset, Character.valueOf(midright));
        map.put(15 + ruleset, Character.valueOf(midboth));
        map.put(14 + ruleset, Character.valueOf(middown));
        map.put(13 + ruleset, Character.valueOf(midup));
        this.addSupportedRuleSet(ruleset);
        return this;
    }

    default public TA_Grid addTopruleCharacterMap(int ruleset, char none, char horizontal, char topleft, char topright, char middown) {
        this.addCharacterMap(ruleset | 0x10, none, horizontal, ' ', topleft, topright, ' ', ' ', ' ', ' ', ' ', middown, ' ');
        return this;
    }

    default public TA_Grid addBottomRuleCharacterMap(int ruleset, char none, char horizontal, char bottomleft, char bottomright, char midup) {
        this.addCharacterMap(ruleset | 0x40, none, horizontal, ' ', ' ', ' ', bottomleft, bottomright, ' ', ' ', ' ', ' ', midup);
        return this;
    }

    default public TA_Grid addMidruleCharacterMap(int ruleset, char none, char vertical, char midleft, char midright, char midboth, char middown, char midup) {
        this.addCharacterMap(ruleset | 0x20, none, ' ', vertical, ' ', ' ', ' ', ' ', midleft, midright, midboth, middown, midup);
        return this;
    }

    default public TA_Grid addCharacterMap(int ruleset, char none, char vertical, char midleft, char midright) {
        this.addCharacterMap(ruleset | 0x80, none, ' ', vertical, ' ', ' ', ' ', ' ', midleft, midright, ' ', ' ', ' ');
        return this;
    }

    public int supportedRulesets();

    public void addSupportedRuleSet(int var1);

    default public boolean hasRuleSet(int set) {
        return (this.supportedRulesets() & set) == set;
    }

    default public ArrayList<Integer> calculateColumns(ArrayList<Object> table) {
        ArrayList<Integer> ret = new ArrayList<Integer>();
        for (Object o : table) {
            if (!(o instanceof Pair) || !((Pair)o).getValue().getClass().isInstance(new String[0][])) continue;
            String[][] ar = (String[][])((Pair)o).getValue();
            for (int r = 0; r < ar.length; ++r) {
                for (int c = 0; c < ar[r].length; ++c) {
                    if (c >= ret.size()) {
                        if (ar[r][c] != null) {
                            ret.add(ar[r][c].length());
                        } else {
                            ret.add(-1);
                        }
                    }
                    if (ar[r][c] == null || ret.get(c) != -1 && ar[r][c].length() >= ret.get(c)) continue;
                    ret.set(c, ar[r][c].length());
                }
            }
        }
        return ret;
    }

    default public void testRuleType(int type) {
        if ((type & 0x200) == 512) {
            Validate.validState((boolean)this.hasRuleSet(512), (String)"strong rule required but no strong character map in grid", (Object[])new Object[0]);
        }
        if ((type & 0x400) == 1024) {
            Validate.validState((boolean)this.hasRuleSet(1024), (String)"heavy rule required but no heavy character map in grid", (Object[])new Object[0]);
        }
        if ((type & 0x800) == 2048) {
            Validate.validState((boolean)this.hasRuleSet(2048), (String)"light rule required but no light character map in grid", (Object[])new Object[0]);
        }
    }

    default public ArrayList<StrBuilder> addGrid(Collection<Object> content, TA_GridThemes theme) {
        return this.addGrid(content, theme.get());
    }

    default public ArrayList<StrBuilder> addGrid(Collection<Object> content, TA_GridThemes theme, TA_GridThemeOptions options) {
        return this.addGrid(content, theme.get() | options.get());
    }

    default public ArrayList<StrBuilder> addGrid(Collection<Object> content, int mode) {
        Validate.notNull(content);
        Validate.noNullElements(content);
        Validate.validState((content.size() > 0 ? 1 : 0) != 0, (String)"no content provided, size of collection was 0", (Object[])new Object[0]);
        ArrayList<Object> table = new ArrayList<Object>(content);
        ArrayList<ArrayList<Object>> frame = new ArrayList<ArrayList<Object>>();
        ArrayList<Integer> columns = this.calculateColumns(table);
        Validate.validState((columns.size() > 0 ? 1 : 0) != 0, (String)"there was no content provided to draw a grid around", (Object[])new Object[0]);
        for (int i = 0; i < table.size(); ++i) {
            if (table.get(i) instanceof Integer) {
                int ruletype = (Integer)table.get(i);
                this.testRuleType(ruletype);
                if (i == 0) {
                    TA_GridHelpers.addRule(TA_GridHelpers.topRule, mode, ruletype | 0x10, columns, frame);
                    continue;
                }
                if (i == table.size() - 1) {
                    TA_GridHelpers.addRule(TA_GridHelpers.bottomRule, mode, ruletype | 0x40, columns, frame);
                    continue;
                }
                TA_GridHelpers.addRule(TA_GridHelpers.midRule, mode, ruletype | 0x20, columns, frame);
                continue;
            }
            if (table.get(i) instanceof Pair) {
                if (!((Pair)table.get(i)).getValue().getClass().isInstance(new String[0][])) continue;
                String[][] ar = (String[][])((Pair)table.get(i)).getValue();
                int ruletype = (Integer)((Pair)table.get(i)).getKey();
                this.testRuleType(ruletype);
                TA_GridHelpers.addContentRow(ar, mode, ruletype | 0x80, frame);
                continue;
            }
            throw new IllegalArgumentException("unknown object type in content, found: <" + table.get(i).getClass().getSimpleName() + ">");
        }
        Map<Integer, Character> cmap = this.getCharacterMap();
        ArrayList<StrBuilder> ret = new ArrayList<StrBuilder>();
        for (int i = 0; i < frame.size(); ++i) {
            StrBuilder sb = new StrBuilder();
            for (int k = 0; k < ((ArrayList)frame.get(i)).size(); ++k) {
                Object o = frame.get(i).get(k);
                if (o instanceof Integer) {
                    int postype = (Integer)o;
                    postype = TA_GridHelpers.adjustBorder(postype, i, k, mode, frame);
                    postype = TA_GridHelpers.convertBorders(postype, i, k, frame.size() - 1, frame.get(i).size() - 1, mode);
                    Character c = cmap.get(postype = TA_GridHelpers.convertConnectors(postype, i, k, frame.size() - 1, frame.get(i).size() - 1, mode));
                    if (c == null) {
                        postype &= 0xFFFFFFEF;
                        postype &= 0xFFFFFFDF;
                        postype &= 0xFFFFFFBF;
                        c = cmap.get(postype &= 0xFFFFFF7F);
                    }
                    Validate.validState((c != null ? 1 : 0) != 0, (String)("problem creating a border character, did not find character for <" + c + ">"), (Object[])new Object[0]);
                    sb.append((Object)c);
                }
                if (!(o instanceof Character)) continue;
                sb.append(o);
            }
            ret.add(sb);
        }
        return ret;
    }

    default public StrBuilder toDoc() {
        ArrayList<StrBuilder> normalGrid = this.addGrid(TA_GridHelpers.todocEmptyContent(256), TA_GridThemes.FULL);
        ArrayList<StrBuilder> strongGrid = this.hasRuleSet(512) ? this.addGrid(TA_GridHelpers.todocEmptyContent(512), TA_GridThemes.FULL) : null;
        ArrayList<StrBuilder> heavyGrid = this.hasRuleSet(1024) ? this.addGrid(TA_GridHelpers.todocEmptyContent(1024), TA_GridThemes.FULL) : null;
        ArrayList<StrBuilder> lightGrid = this.hasRuleSet(2048) ? this.addGrid(TA_GridHelpers.todocEmptyContent(2048), TA_GridThemes.FULL) : null;
        int strongRule = this.hasRuleSet(512) ? 512 : 256;
        int heavyRule = this.hasRuleSet(1024) ? 1024 : strongRule;
        ArrayList<StrBuilder> exampleGrid = this.addGrid(TA_GridHelpers.todocExampleContent(this.hasRuleSet(2048) ? 2048 : 256, strongRule, heavyRule), TA_GridThemes.FULL);
        return new StrBuilder().appendWithSeparators(TA_GridHelpers.todocBuildAll(normalGrid, strongGrid, heavyGrid, lightGrid, exampleGrid), "\n");
    }

    public static TA_Grid create(final String description) {
        Validate.notBlank((CharSequence)description);
        return new TA_Grid(){
            Map<Integer, Character> map = new HashMap<Integer, Character>();
            protected int supportedRuleSet = 256;

            @Override
            public Map<Integer, Character> getCharacterMap() {
                return this.map;
            }

            public String getDescription() {
                return description;
            }

            @Override
            public int supportedRulesets() {
                return this.supportedRuleSet;
            }

            @Override
            public void addSupportedRuleSet(int set) {
                this.supportedRuleSet |= set;
            }
        };
    }
}

