/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.logs;

import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.internal.ValidationUtil;
import io.opentelemetry.api.logs.EventBuilder;
import io.opentelemetry.api.logs.LogRecordBuilder;
import io.opentelemetry.api.logs.Logger;
import io.opentelemetry.api.logs.LoggerProvider;
import io.opentelemetry.sdk.common.InstrumentationScopeInfo;
import io.opentelemetry.sdk.logs.LoggerSharedState;
import io.opentelemetry.sdk.logs.SdkLogRecordBuilder;
import java.util.logging.Level;
import javax.annotation.Nullable;

final class SdkLogger
implements Logger {
    private static final Logger NOOP_LOGGER_WITH_DOMAIN = LoggerProvider.noop().loggerBuilder("unused").setEventDomain("unused").build();
    private final LoggerSharedState loggerSharedState;
    private final InstrumentationScopeInfo instrumentationScopeInfo;
    @Nullable
    private final String eventDomain;

    SdkLogger(LoggerSharedState loggerSharedState, InstrumentationScopeInfo instrumentationScopeInfo) {
        this(loggerSharedState, instrumentationScopeInfo, null);
    }

    SdkLogger(LoggerSharedState loggerSharedState, InstrumentationScopeInfo instrumentationScopeInfo, @Nullable String eventDomain) {
        this.loggerSharedState = loggerSharedState;
        this.instrumentationScopeInfo = instrumentationScopeInfo;
        this.eventDomain = eventDomain;
    }

    SdkLogger withEventDomain(String eventDomain) {
        if (!eventDomain.equals(this.eventDomain)) {
            return new SdkLogger(this.loggerSharedState, this.instrumentationScopeInfo, eventDomain);
        }
        return this;
    }

    public EventBuilder eventBuilder(String eventName) {
        if (this.eventDomain == null) {
            ValidationUtil.log((String)"Cannot emit event from Logger without event domain. Please use LoggerBuilder#setEventDomain(String) when obtaining Logger.", (Level)Level.WARNING);
            return NOOP_LOGGER_WITH_DOMAIN.eventBuilder(eventName);
        }
        return new SdkLogRecordBuilder(this.loggerSharedState, this.instrumentationScopeInfo).setAttribute(AttributeKey.stringKey((String)"event.domain"), this.eventDomain).setAttribute(AttributeKey.stringKey((String)"event.name"), eventName);
    }

    public LogRecordBuilder logRecordBuilder() {
        return new SdkLogRecordBuilder(this.loggerSharedState, this.instrumentationScopeInfo);
    }

    InstrumentationScopeInfo getInstrumentationScopeInfo() {
        return this.instrumentationScopeInfo;
    }
}

