/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v122.audits.model;

import java.util.Objects;
import java.util.Optional;
import org.openqa.selenium.devtools.v122.audits.model.AffectedRequest;
import org.openqa.selenium.devtools.v122.audits.model.SourceCodeLocation;
import org.openqa.selenium.devtools.v122.network.model.ClientSecurityState;
import org.openqa.selenium.devtools.v122.network.model.CorsErrorStatus;
import org.openqa.selenium.devtools.v122.network.model.IPAddressSpace;
import org.openqa.selenium.json.JsonInput;

public class CorsIssueDetails {
    private final CorsErrorStatus corsErrorStatus;
    private final Boolean isWarning;
    private final AffectedRequest request;
    private final Optional<SourceCodeLocation> location;
    private final Optional<String> initiatorOrigin;
    private final Optional<IPAddressSpace> resourceIPAddressSpace;
    private final Optional<ClientSecurityState> clientSecurityState;

    public CorsIssueDetails(CorsErrorStatus corsErrorStatus, Boolean isWarning, AffectedRequest request, Optional<SourceCodeLocation> location, Optional<String> initiatorOrigin, Optional<IPAddressSpace> resourceIPAddressSpace, Optional<ClientSecurityState> clientSecurityState) {
        this.corsErrorStatus = Objects.requireNonNull(corsErrorStatus, "corsErrorStatus is required");
        this.isWarning = Objects.requireNonNull(isWarning, "isWarning is required");
        this.request = Objects.requireNonNull(request, "request is required");
        this.location = location;
        this.initiatorOrigin = initiatorOrigin;
        this.resourceIPAddressSpace = resourceIPAddressSpace;
        this.clientSecurityState = clientSecurityState;
    }

    public CorsErrorStatus getCorsErrorStatus() {
        return this.corsErrorStatus;
    }

    public Boolean getIsWarning() {
        return this.isWarning;
    }

    public AffectedRequest getRequest() {
        return this.request;
    }

    public Optional<SourceCodeLocation> getLocation() {
        return this.location;
    }

    public Optional<String> getInitiatorOrigin() {
        return this.initiatorOrigin;
    }

    public Optional<IPAddressSpace> getResourceIPAddressSpace() {
        return this.resourceIPAddressSpace;
    }

    public Optional<ClientSecurityState> getClientSecurityState() {
        return this.clientSecurityState;
    }

    private static CorsIssueDetails fromJson(JsonInput input) {
        CorsErrorStatus corsErrorStatus = null;
        Boolean isWarning = false;
        AffectedRequest request = null;
        Optional<SourceCodeLocation> location = Optional.empty();
        Optional<String> initiatorOrigin = Optional.empty();
        Optional<IPAddressSpace> resourceIPAddressSpace = Optional.empty();
        Optional<ClientSecurityState> clientSecurityState = Optional.empty();
        input.beginObject();
        block18: while (input.hasNext()) {
            switch (input.nextName()) {
                case "corsErrorStatus": {
                    corsErrorStatus = (CorsErrorStatus)input.read(CorsErrorStatus.class);
                    continue block18;
                }
                case "isWarning": {
                    isWarning = input.nextBoolean();
                    continue block18;
                }
                case "request": {
                    request = (AffectedRequest)input.read(AffectedRequest.class);
                    continue block18;
                }
                case "location": {
                    location = Optional.ofNullable((SourceCodeLocation)input.read(SourceCodeLocation.class));
                    continue block18;
                }
                case "initiatorOrigin": {
                    initiatorOrigin = Optional.ofNullable(input.nextString());
                    continue block18;
                }
                case "resourceIPAddressSpace": {
                    resourceIPAddressSpace = Optional.ofNullable((IPAddressSpace)((Object)input.read(IPAddressSpace.class)));
                    continue block18;
                }
                case "clientSecurityState": {
                    clientSecurityState = Optional.ofNullable((ClientSecurityState)input.read(ClientSecurityState.class));
                    continue block18;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new CorsIssueDetails(corsErrorStatus, isWarning, request, location, initiatorOrigin, resourceIPAddressSpace, clientSecurityState);
    }
}

