/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nutch.parse;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.VersionMismatchException;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableUtils;
import org.apache.nutch.metadata.Metadata;
import org.apache.nutch.parse.Outlink;
import org.apache.nutch.parse.Parse;
import org.apache.nutch.parse.ParseData;
import org.apache.nutch.parse.ParseResult;

public class ParseStatus
implements Writable {
    private static final byte VERSION = 2;
    public static final byte NOTPARSED = 0;
    public static final byte SUCCESS = 1;
    public static final byte FAILED = 2;
    public static final String[] majorCodes = new String[]{"notparsed", "success", "failed"};
    public static final short SUCCESS_REDIRECT = 100;
    public static final short FAILED_EXCEPTION = 200;
    public static final short FAILED_TRUNCATED = 202;
    public static final short FAILED_INVALID_FORMAT = 203;
    public static final short FAILED_MISSING_PARTS = 204;
    public static final short FAILED_MISSING_CONTENT = 205;
    public static final ParseStatus STATUS_NOTPARSED = new ParseStatus(0);
    public static final ParseStatus STATUS_SUCCESS = new ParseStatus(1);
    public static final ParseStatus STATUS_FAILURE = new ParseStatus(2);
    private byte majorCode = 0;
    private short minorCode = 0;
    private String[] args = null;

    public byte getVersion() {
        return 2;
    }

    public ParseStatus() {
    }

    public ParseStatus(int majorCode, int minorCode, String[] args) {
        this.args = args;
        this.majorCode = (byte)majorCode;
        this.minorCode = (short)minorCode;
    }

    public ParseStatus(int majorCode) {
        this(majorCode, 0, (String[])null);
    }

    public ParseStatus(int majorCode, String[] args) {
        this(majorCode, 0, args);
    }

    public ParseStatus(int majorCode, int minorCode) {
        this(majorCode, minorCode, (String[])null);
    }

    public ParseStatus(int majorCode, int minorCode, String message) {
        this(majorCode, minorCode, new String[]{message});
    }

    public ParseStatus(int majorCode, String message) {
        this(majorCode, 0, new String[]{message});
    }

    public ParseStatus(Throwable t) {
        this(2, 200, new String[]{t.toString()});
    }

    public static ParseStatus read(DataInput in) throws IOException {
        ParseStatus res = new ParseStatus();
        res.readFields(in);
        return res;
    }

    public void readFields(DataInput in) throws IOException {
        byte version = in.readByte();
        switch (version) {
            case 1: {
                this.majorCode = in.readByte();
                this.minorCode = in.readShort();
                this.args = WritableUtils.readCompressedStringArray((DataInput)in);
                break;
            }
            case 2: {
                this.majorCode = in.readByte();
                this.minorCode = in.readShort();
                this.args = WritableUtils.readStringArray((DataInput)in);
                break;
            }
            default: {
                throw new VersionMismatchException(2, version);
            }
        }
    }

    public void write(DataOutput out) throws IOException {
        out.writeByte(2);
        out.writeByte(this.majorCode);
        out.writeShort(this.minorCode);
        if (this.args == null) {
            out.writeInt(-1);
        } else {
            WritableUtils.writeStringArray((DataOutput)out, (String[])this.args);
        }
    }

    public boolean isSuccess() {
        return this.majorCode == 1;
    }

    public String getMessage() {
        if (this.args != null && this.args.length > 0 && this.args[0] != null) {
            return this.args[0];
        }
        return null;
    }

    public String[] getArgs() {
        return this.args;
    }

    public int getMajorCode() {
        return this.majorCode;
    }

    public int getMinorCode() {
        return this.minorCode;
    }

    public Parse getEmptyParse(Configuration conf) {
        return new EmptyParseImpl(this, conf);
    }

    public ParseResult getEmptyParseResult(String url, Configuration conf) {
        return ParseResult.createParseResult(url, this.getEmptyParse(conf));
    }

    public String toString() {
        StringBuffer res = new StringBuffer();
        String name = null;
        name = this.majorCode >= 0 && this.majorCode < majorCodes.length ? majorCodes[this.majorCode] : "UNKNOWN!";
        res.append(name + "(" + this.majorCode + "," + this.minorCode + ")");
        if (this.args != null) {
            if (this.args.length == 1) {
                res.append(": " + String.valueOf(this.args[0]));
            } else {
                for (int i = 0; i < this.args.length; ++i) {
                    if (this.args[i] == null) continue;
                    res.append(", args[" + i + "]=" + String.valueOf(this.args[i]));
                }
            }
        }
        return res.toString();
    }

    public void setArgs(String[] args) {
        this.args = args;
    }

    public void setMessage(String msg) {
        if (this.args == null || this.args.length == 0) {
            this.args = new String[1];
        }
        this.args[0] = msg;
    }

    public void setMajorCode(byte majorCode) {
        this.majorCode = majorCode;
    }

    public void setMinorCode(short minorCode) {
        this.minorCode = minorCode;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (!(o instanceof ParseStatus)) {
            return false;
        }
        boolean res = true;
        ParseStatus other = (ParseStatus)o;
        boolean bl = res = res && this.majorCode == other.majorCode && this.minorCode == other.minorCode;
        if (!res) {
            return res;
        }
        if (this.args == null) {
            return other.args == null;
        }
        if (other.args == null) {
            return false;
        }
        if (other.args.length != this.args.length) {
            return false;
        }
        for (int i = 0; i < this.args.length; ++i) {
            if (this.args[i].equals(other.args[i])) continue;
            return false;
        }
        return true;
    }

    private static class EmptyParseImpl
    implements Parse {
        private ParseData data = null;

        public EmptyParseImpl(ParseStatus status, Configuration conf) {
            this.data = new ParseData(status, "", new Outlink[0], new Metadata(), new Metadata());
        }

        @Override
        public ParseData getData() {
            return this.data;
        }

        @Override
        public String getText() {
            return "";
        }

        @Override
        public boolean isCanonical() {
            return true;
        }
    }
}

