/*
 * Decompiled with CFR 0.152.
 */
package org.archive.util.binsearch;

import com.google.common.io.ByteStreams;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.archive.util.binsearch.SeekableLineReader;
import org.archive.util.zip.GZIPMembersInputStream;

public abstract class AbstractSeekableLineReader
implements SeekableLineReader {
    public static final Charset UTF8 = StandardCharsets.UTF_8;
    protected int blockSize = 131072;
    protected boolean closed = false;
    protected boolean bufferFully = false;
    protected BufferedReader br;
    protected InputStream is;

    public AbstractSeekableLineReader() {
    }

    public AbstractSeekableLineReader(int blockSize) {
        this.blockSize = blockSize;
    }

    @Override
    public void seek(long offset) throws IOException {
        this.seekWithMaxRead(offset, false, -1);
    }

    @Override
    public void seekWithMaxRead(long offset, boolean gzip, int maxLength) throws IOException {
        if (this.closed) {
            throw new IOException("Seek after close()");
        }
        this.br = null;
        try {
            this.is = this.doSeekLoad(offset, maxLength);
            if (this.bufferFully && maxLength > 0) {
                byte[] buffer = new byte[maxLength];
                ByteStreams.readFully((InputStream)this.is, (byte[])buffer);
                this.doClose();
                this.is = new ByteArrayInputStream(buffer);
            }
            if (gzip) {
                this.is = new GZIPMembersInputStream(this.is, this.blockSize);
            }
        }
        catch (IOException io) {
            this.doClose();
            throw io;
        }
    }

    protected abstract InputStream doSeekLoad(long var1, int var3) throws IOException;

    protected abstract void doClose() throws IOException;

    @Override
    public InputStream getInputStream() {
        return new SLRClosingInputStream(this.is);
    }

    @Override
    public void skipLine() throws IOException {
        this.readLine();
    }

    @Override
    public String readLine() throws IOException {
        if (this.is == null) {
            this.seek(0L);
        }
        if (this.br == null) {
            InputStreamReader isr = new InputStreamReader(this.is, UTF8);
            this.br = new BufferedReader(isr, this.blockSize);
        }
        return this.br.readLine();
    }

    @Override
    public final void close() throws IOException {
        if (this.closed) {
            return;
        }
        this.doClose();
        if (this.br != null) {
            this.br.close();
            this.br = null;
        } else if (this.is != null) {
            this.is.close();
        }
        this.br = null;
        this.is = null;
        this.closed = true;
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    @Override
    public long getSize() throws IOException {
        return 0L;
    }

    @Override
    public void setBufferFully(boolean fully) {
        this.bufferFully = fully;
    }

    public void finalize() {
        if (!this.closed) {
            try {
                this.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    class SLRClosingInputStream
    extends FilterInputStream {
        protected SLRClosingInputStream(InputStream in) {
            super(in);
        }

        @Override
        public void close() throws IOException {
            AbstractSeekableLineReader.this.close();
        }
    }
}

