/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.zstd.okio;

import com.squareup.zstd.Zstd;
import com.squareup.zstd.ZstdDecompressor;
import java.io.Closeable;
import java.io.EOFException;
import java.io.IOException;
import kotlin.ExceptionsKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import okio.Buffer;
import okio.BufferedSource;
import okio.Source;
import okio.Timeout;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0019\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0018\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\u000eH\u0016J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\b\u0010\u0016\u001a\u00020\u0015H\u0002J\b\u0010\u0017\u001a\u00020\u0018H\u0016R\u0010\u0010\u0002\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u000f\u001a\u00020\u00108\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/squareup/zstd/okio/ZstdDecompressSource;", "Lokio/Source;", "source", "Lokio/BufferedSource;", "decompressor", "Lcom/squareup/zstd/ZstdDecompressor;", "<init>", "(Lokio/BufferedSource;Lcom/squareup/zstd/ZstdDecompressor;)V", "inputCursor", "Lokio/Buffer$UnsafeCursor;", "outputBuffer", "Lokio/Buffer;", "outputCursor", "lastDecompressResult", "", "closed", "", "read", "sink", "byteCount", "close", "", "refillIfNecessary", "timeout", "Lokio/Timeout;", "zstd-kmp-okio"})
@SourceDebugExtension(value={"SMAP\nZstdDecompressSource.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ZstdDecompressSource.kt\ncom/squareup/zstd/okio/ZstdDecompressSource\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 Okio.kt\nokio/Okio__OkioKt\n*L\n1#1,116:1\n1#2:117\n72#3:118\n58#3,22:119\n72#3:141\n58#3,4:142\n72#3:146\n58#3,22:147\n66#3,10:169\n62#3,3:179\n77#3,3:182\n*S KotlinDebug\n*F\n+ 1 ZstdDecompressSource.kt\ncom/squareup/zstd/okio/ZstdDecompressSource\n*L\n71#1:118\n71#1:119,22\n87#1:141\n87#1:142,4\n91#1:146\n91#1:147,22\n87#1:169,10\n87#1:179,3\n87#1:182,3\n*E\n"})
public final class ZstdDecompressSource
implements Source {
    @JvmField
    @NotNull
    public final BufferedSource source;
    @NotNull
    private final ZstdDecompressor decompressor;
    @NotNull
    private final Buffer.UnsafeCursor inputCursor;
    @NotNull
    private final Buffer outputBuffer;
    @NotNull
    private final Buffer.UnsafeCursor outputCursor;
    private long lastDecompressResult;
    @JvmField
    public boolean closed;

    public ZstdDecompressSource(@NotNull BufferedSource source, @NotNull ZstdDecompressor decompressor) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)decompressor, (String)"decompressor");
        this.source = source;
        this.decompressor = decompressor;
        this.inputCursor = new Buffer.UnsafeCursor();
        this.outputBuffer = new Buffer();
        this.outputCursor = new Buffer.UnsafeCursor();
    }

    public long read(@NotNull Buffer sink, long byteCount) {
        Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
        if (!(byteCount >= 0L)) {
            boolean $i$a$-require-ZstdDecompressSource$read$22 = false;
            String $i$a$-require-ZstdDecompressSource$read$22 = "byteCount < 0: " + byteCount;
            throw new IllegalArgumentException($i$a$-require-ZstdDecompressSource$read$22.toString());
        }
        if (!(!this.closed)) {
            boolean bl = false;
            String string = "closed";
            throw new IllegalStateException(string.toString());
        }
        if (byteCount == 0L) {
            return 0L;
        }
        this.refillIfNecessary();
        return this.outputBuffer.read(sink, byteCount);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void close() {
        Unit unit;
        Throwable thrown$iv;
        block21: {
            if (this.closed) {
                return;
            }
            this.closed = true;
            this.outputBuffer.clear();
            Closeable $this$use$iv = (Closeable)this.source;
            boolean $i$f$use = false;
            thrown$iv = null;
            try {
                BufferedSource it = (BufferedSource)$this$use$iv;
                boolean bl = false;
                AutoCloseable autoCloseable = (AutoCloseable)this.decompressor;
                Throwable throwable = null;
                try {
                    ZstdDecompressor it2 = (ZstdDecompressor)autoCloseable;
                    boolean bl2 = false;
                    it2 = Unit.INSTANCE;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
                }
                unit = Unit.INSTANCE;
            }
            catch (Throwable t$iv) {
                try {
                    thrown$iv = t$iv;
                    unit = null;
                    break block21;
                }
                catch (Throwable throwable3) {
                    throw throwable3;
                }
                finally {
                    block22: {
                        try {
                            Closeable closeable = $this$use$iv;
                            if (closeable != null) {
                                closeable.close();
                            }
                        }
                        catch (Throwable t$iv2) {
                            if (thrown$iv == null) {
                                thrown$iv = t$iv2;
                                break block22;
                            }
                            ExceptionsKt.addSuppressed((Throwable)thrown$iv, (Throwable)t$iv2);
                        }
                    }
                }
            }
            try {
                Closeable closeable = $this$use$iv;
                if (closeable != null) {
                    closeable.close();
                }
            }
            catch (Throwable t$iv) {
                thrown$iv = t$iv;
            }
        }
        Unit result$iv = unit;
        Throwable throwable = thrown$iv;
        if (throwable == null) return;
        throw throwable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void refillIfNecessary() {
        long result;
        String string;
        do {
            Object outputCursor;
            Throwable thrown$iv;
            block34: {
                if (!this.outputBuffer.exhausted()) return;
                if (!this.source.request(1L)) {
                    if (this.lastDecompressResult == 0L) return;
                    throw new EOFException("EOF before end of stream");
                }
                result = 0L;
                Closeable $this$use$iv = (Closeable)this.outputBuffer.readAndWriteUnsafe(this.outputCursor);
                boolean $i$f$use = false;
                thrown$iv = null;
                try {
                    Unit unit;
                    Throwable thrown$iv2;
                    long outputSizeBefore;
                    block32: {
                        outputCursor = (Buffer.UnsafeCursor)$this$use$iv;
                        boolean bl = false;
                        outputSizeBefore = this.outputBuffer.size();
                        outputCursor.expandBuffer(1);
                        Closeable $this$use$iv2 = (Closeable)this.source.getBuffer().readUnsafe(this.inputCursor);
                        boolean $i$f$use2 = false;
                        thrown$iv2 = null;
                        try {
                            Buffer.UnsafeCursor inputCursor = (Buffer.UnsafeCursor)$this$use$iv2;
                            boolean bl2 = false;
                            inputCursor.next();
                            Intrinsics.checkNotNull((Object)outputCursor.data);
                            int n = outputCursor.end;
                            int n2 = outputCursor.start;
                            Intrinsics.checkNotNull((Object)inputCursor.data);
                            result = this.decompressor.decompressStream(outputCursor.data, n, n2, inputCursor.data, inputCursor.end, inputCursor.start);
                            unit = Unit.INSTANCE;
                        }
                        catch (Throwable t$iv) {
                            try {
                                thrown$iv2 = t$iv;
                                unit = null;
                                break block32;
                            }
                            catch (Throwable throwable) {
                                throw throwable;
                            }
                            finally {
                                block33: {
                                    try {
                                        Closeable closeable = $this$use$iv2;
                                        if (closeable != null) {
                                            closeable.close();
                                        }
                                    }
                                    catch (Throwable t$iv2) {
                                        if (thrown$iv2 == null) {
                                            thrown$iv2 = t$iv2;
                                            break block33;
                                        }
                                        ExceptionsKt.addSuppressed((Throwable)thrown$iv2, (Throwable)t$iv2);
                                    }
                                }
                            }
                        }
                        try {
                            Closeable closeable = $this$use$iv2;
                            if (closeable != null) {
                                closeable.close();
                            }
                        }
                        catch (Throwable t$iv) {
                            thrown$iv2 = t$iv;
                        }
                    }
                    Unit result$iv = unit;
                    Throwable throwable = thrown$iv2;
                    if (throwable != null) {
                        throw throwable;
                    }
                    this.source.skip((long)this.decompressor.inputBytesProcessed);
                    outputCursor = outputCursor.resizeBuffer(outputSizeBefore + (long)this.decompressor.outputBytesProcessed);
                }
                catch (Throwable t$iv) {
                    try {
                        thrown$iv = t$iv;
                        outputCursor = null;
                        break block34;
                    }
                    catch (Throwable throwable2) {
                        throw throwable2;
                    }
                    finally {
                        block35: {
                            try {
                                Closeable closeable = $this$use$iv;
                                if (closeable != null) {
                                    closeable.close();
                                }
                            }
                            catch (Throwable t$iv3) {
                                if (thrown$iv == null) {
                                    thrown$iv = t$iv3;
                                    break block35;
                                }
                                ExceptionsKt.addSuppressed((Throwable)thrown$iv, (Throwable)t$iv3);
                            }
                        }
                    }
                }
                try {
                    Closeable closeable = $this$use$iv;
                    if (closeable != null) {
                        closeable.close();
                    }
                }
                catch (Throwable t$iv) {
                    thrown$iv = t$iv;
                }
            }
            Buffer.UnsafeCursor result$iv = outputCursor;
            Throwable throwable = thrown$iv;
            if (throwable != null) {
                throw throwable;
            }
            this.lastDecompressResult = result;
        } while ((string = Zstd.getErrorName((long)result)) == null);
        String errorName = string;
        boolean bl = false;
        throw new IOException("zstd decompress failed: " + errorName);
    }

    @NotNull
    public Timeout timeout() {
        return this.source.timeout();
    }
}

