/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.formats.moses;

import java.io.IOException;
import java.util.LinkedList;
import opennlp.tools.sentdetect.EmptyLinePreprocessorStream;
import opennlp.tools.sentdetect.SentenceSample;
import opennlp.tools.util.FilterObjectStream;
import opennlp.tools.util.ObjectStream;
import opennlp.tools.util.Span;

public class MosesSentenceSampleStream
extends FilterObjectStream<String, SentenceSample> {
    public MosesSentenceSampleStream(ObjectStream<String> sentences) {
        super((ObjectStream)new EmptyLinePreprocessorStream(sentences));
    }

    public SentenceSample read() throws IOException {
        String sentence;
        StringBuilder sentencesString = new StringBuilder();
        LinkedList<Span> sentenceSpans = new LinkedList<Span>();
        for (int i = 0; i < 25 && (sentence = (String)this.samples.read()) != null; ++i) {
            int begin = sentencesString.length();
            sentence = sentence.trim();
            sentencesString.append(sentence);
            int end = sentencesString.length();
            sentenceSpans.add(new Span(begin, end));
            sentencesString.append(' ');
        }
        if (!sentenceSpans.isEmpty()) {
            return new SentenceSample((CharSequence)sentencesString.toString(), sentenceSpans.toArray(new Span[0]));
        }
        return null;
    }
}

