/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.cmdline.parser;

import java.io.IOException;
import opennlp.tools.cmdline.parser.ModelUpdaterTool;
import opennlp.tools.cmdline.parser.ParserTrainerTool;
import opennlp.tools.dictionary.Dictionary;
import opennlp.tools.ml.EventTrainer;
import opennlp.tools.ml.TrainerFactory;
import opennlp.tools.ml.model.MaxentModel;
import opennlp.tools.parser.Parse;
import opennlp.tools.parser.ParserEventTypeEnum;
import opennlp.tools.parser.ParserModel;
import opennlp.tools.parser.chunking.ParserEventStream;
import opennlp.tools.util.ObjectStream;
import opennlp.tools.util.TrainingParameters;
import opennlp.tools.util.model.ModelUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BuildModelUpdaterTool
extends ModelUpdaterTool {
    private static final Logger logger = LoggerFactory.getLogger(BuildModelUpdaterTool.class);

    @Override
    public String getShortDescription() {
        return "Trains and updates the build model in a parser model";
    }

    @Override
    protected ParserModel trainAndUpdate(ParserModel originalModel, ObjectStream<Parse> parseSamples, ModelUpdaterTool.ModelUpdaterParams parameters) throws IOException {
        Dictionary mdict = ParserTrainerTool.buildDictionary(parseSamples, originalModel.getHeadRules(), 5);
        parseSamples.reset();
        logger.info("Training builder");
        ParserEventStream bes = new ParserEventStream(parseSamples, originalModel.getHeadRules(), ParserEventTypeEnum.BUILD, mdict);
        EventTrainer trainer = TrainerFactory.getEventTrainer((TrainingParameters)ModelUtil.createDefaultTrainingParameters(), null);
        MaxentModel buildModel = trainer.train((ObjectStream)bes);
        parseSamples.close();
        return originalModel.updateBuildModel(buildModel);
    }
}

