/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.intercept;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import javax.interceptor.InvocationContext;
import org.apache.webbeans.util.ExceptionUtil;

public abstract class AbstractInvocationContext<T>
implements InvocationContext {
    private T target;
    private AccessibleObject member;
    private Object[] parameters;
    private Map<String, Object> contextData;
    private Object timer;

    public AbstractInvocationContext(T target, AccessibleObject member, Object[] parameters) {
        this.target = target;
        this.member = member;
        this.parameters = parameters;
        if (!member.isAccessible()) {
            member.setAccessible(true);
        }
    }

    public AbstractInvocationContext(T target, Method method, Object[] parameters, Object timer) {
        this(target, method, parameters);
        this.timer = timer;
    }

    public T getTarget() {
        return this.target;
    }

    public Method getMethod() {
        if (Method.class.isInstance(this.member)) {
            return (Method)Method.class.cast(this.member);
        }
        return null;
    }

    public Object[] getParameters() {
        return this.parameters;
    }

    public void setParameters(Object[] parameters) {
        this.parameters = parameters;
    }

    public Map<String, Object> getContextData() {
        if (this.contextData == null) {
            this.contextData = new HashMap<String, Object>();
        }
        return this.contextData;
    }

    public Object getTimer() {
        return this.timer;
    }

    public Object proceed() throws Exception {
        try {
            Method m = this.getMethod();
            if (m != null) {
                return m.invoke(this.target, this.parameters);
            }
            return this.getConstructor().newInstance(this.parameters);
        }
        catch (InvocationTargetException ite) {
            throw ExceptionUtil.throwAsRuntimeException(ite.getCause());
        }
    }

    public Constructor getConstructor() {
        if (Constructor.class.isInstance(this.member)) {
            return (Constructor)Constructor.class.cast(this.member);
        }
        return null;
    }
}

