/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.eip.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public class CipSecurityInformation extends CommandSpecificDataItem implements Message {

  // Accessors for discriminator values.
  public Integer getItemType() {
    return (int) 0x0086;
  }

  // Properties.
  protected final List<Short> todoImplement;

  public CipSecurityInformation(List<Short> todoImplement) {
    super();
    this.todoImplement = todoImplement;
  }

  public List<Short> getTodoImplement() {
    return todoImplement;
  }

  @Override
  protected void serializeCommandSpecificDataItemChild(WriteBuffer writeBuffer)
      throws SerializationException {
    PositionAware positionAware = writeBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
    writeBuffer.pushContext("CipSecurityInformation");

    // Implicit Field (itemLength) (Used for parsing, but its value is not stored as it's implicitly
    // given by the objects content)
    int itemLength = (int) (COUNT(getTodoImplement()));
    writeImplicitField("itemLength", itemLength, writeUnsignedInt(writeBuffer, 16));

    // Array Field (todoImplement)
    writeSimpleTypeArrayField("todoImplement", todoImplement, writeUnsignedShort(writeBuffer, 8));

    writeBuffer.popContext("CipSecurityInformation");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = super.getLengthInBits();
    CipSecurityInformation _value = this;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    // Implicit Field (itemLength)
    lengthInBits += 16;

    // Array field
    if (todoImplement != null) {
      lengthInBits += 8 * todoImplement.size();
    }

    return lengthInBits;
  }

  public static CommandSpecificDataItemBuilder staticParseCommandSpecificDataItemBuilder(
      ReadBuffer readBuffer) throws ParseException {
    readBuffer.pullContext("CipSecurityInformation");
    PositionAware positionAware = readBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    int itemLength = readImplicitField("itemLength", readUnsignedInt(readBuffer, 16));

    List<Short> todoImplement =
        readCountArrayField("todoImplement", readUnsignedShort(readBuffer, 8), itemLength);

    readBuffer.closeContext("CipSecurityInformation");
    // Create the instance
    return new CipSecurityInformationBuilderImpl(todoImplement);
  }

  public static class CipSecurityInformationBuilderImpl
      implements CommandSpecificDataItem.CommandSpecificDataItemBuilder {
    private final List<Short> todoImplement;

    public CipSecurityInformationBuilderImpl(List<Short> todoImplement) {
      this.todoImplement = todoImplement;
    }

    public CipSecurityInformation build() {
      CipSecurityInformation cipSecurityInformation = new CipSecurityInformation(todoImplement);
      return cipSecurityInformation;
    }
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof CipSecurityInformation)) {
      return false;
    }
    CipSecurityInformation that = (CipSecurityInformation) o;
    return (getTodoImplement() == that.getTodoImplement()) && super.equals(that) && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(super.hashCode(), getTodoImplement());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
