/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.ads.discovery.readwrite;

import java.util.HashMap;
import java.util.Map;

// Code generated by code-generation. DO NOT EDIT.

public enum AdsPortNumbers {
  LOGGER((int) 100),
  EVENT_LOGGER((int) 110),
  IO((int) 300),
  ADDITIONAL_TASK_1((int) 301),
  ADDITIONAL_TASK_2((int) 302),
  NC((int) 500),
  PLC_RUNTIME_SYSTEM_1((int) 801),
  PLC_RUNTIME_SYSTEM_2((int) 811),
  PLC_RUNTIME_SYSTEM_3((int) 821),
  PLC_RUNTIME_SYSTEM_4((int) 831),
  CAM_SWITCH((int) 900),
  SYSTEM_SERVICE((int) 10000),
  SCOPE((int) 14000);
  private static final Map<Integer, AdsPortNumbers> map;

  static {
    map = new HashMap<>();
    for (AdsPortNumbers value : AdsPortNumbers.values()) {
      map.put((int) value.getValue(), value);
    }
  }

  private final int value;

  AdsPortNumbers(int value) {
    this.value = value;
  }

  public int getValue() {
    return value;
  }

  public static AdsPortNumbers enumForValue(int value) {
    return map.get(value);
  }

  public static Boolean isDefined(int value) {
    return map.containsKey(value);
  }
}
