/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.portals.applications.webcontent2.rewriter;

/**
 * ContentRewritingException which defines a general exception that a ContentRewriter 
 * can throw when it is unable to perform its operation successfully.
 */
public class ContentRewritingException extends RuntimeException
{
    private static final long serialVersionUID = 1L;

    /**
     * Constructs a new ContentRewritingException exception.
     */
    public ContentRewritingException()
    {
        super();
    }

    /**
     * Constructs a new ContentRewritingException exception with the given message.
     * 
     * @param message
     */
    public ContentRewritingException(String message)
    {
        super(message);
    }

    /**
     * Constructs a new ContentRewritingException exception when the ContentRewritingException 
     * needs to do the following: throw an exception include the "nested" exception include a description message.
     * 
     * @param message
     * @param nested
     */
    public ContentRewritingException(String message, Throwable nested)
    {
        super(message, nested);
    }

    /**
     * Constructs a new ContentRewritingException exception with the nested exception.
     * 
     * @param nested
     */
    public ContentRewritingException(Throwable nested)
    {
        super(nested);
    }
}
