/*
 * Decompiled with CFR 0.152.
 */
package com.ibatis.jpetstore.presentation;

import com.ibatis.common.util.PaginatedList;
import com.ibatis.jpetstore.domain.Account;
import com.ibatis.jpetstore.domain.Order;
import com.ibatis.jpetstore.presentation.AccountBean;
import com.ibatis.jpetstore.presentation.CartBean;
import com.ibatis.jpetstore.service.AccountService;
import com.ibatis.jpetstore.service.OrderService;
import com.ibatis.struts.ActionContext;
import com.ibatis.struts.BaseBean;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class OrderBean
extends BaseBean {
    private static final AccountService accountService = AccountService.getInstance();
    private static final OrderService orderService = OrderService.getInstance();
    private static final List CARD_TYPE_LIST;
    private Order order = new Order();
    private int orderId;
    private boolean shippingAddressRequired = false;
    private boolean confirmed = false;
    private PaginatedList orderList;
    private String pageDirection;

    public int getOrderId() {
        return this.orderId;
    }

    public void setOrderId(int orderId) {
        this.orderId = orderId;
    }

    public Order getOrder() {
        return this.order;
    }

    public void setOrder(Order order) {
        this.order = order;
    }

    public boolean isShippingAddressRequired() {
        return this.shippingAddressRequired;
    }

    public void setShippingAddressRequired(boolean shippingAddressRequired) {
        this.shippingAddressRequired = shippingAddressRequired;
    }

    public boolean isConfirmed() {
        return this.confirmed;
    }

    public void setConfirmed(boolean confirmed) {
        this.confirmed = confirmed;
    }

    public List getCreditCardTypes() {
        return CARD_TYPE_LIST;
    }

    public List getOrderList() {
        return this.orderList;
    }

    public String getPageDirection() {
        return this.pageDirection;
    }

    public void setPageDirection(String pageDirection) {
        this.pageDirection = pageDirection;
    }

    public String newOrderForm() {
        Map sessionMap = ActionContext.getActionContext().getSessionMap();
        AccountBean accountBean = (AccountBean)sessionMap.get("accountBean");
        CartBean cartBean = (CartBean)sessionMap.get("cartBean");
        this.clear();
        if (accountBean == null || !accountBean.isAuthenticated()) {
            ActionContext.getActionContext().setSimpleMessage("You must sign on before attempting to check out.  Please sign on and try checking out again.");
            return "signon";
        }
        if (cartBean != null) {
            Account account = accountService.getAccount(accountBean.getAccount().getUsername());
            this.order.initOrder(account, cartBean.getCart());
            return "success";
        }
        ActionContext.getActionContext().setSimpleMessage("An order could not be created because a cart could not be found.");
        return "failure";
    }

    public String newOrder() {
        Map sessionMap = ActionContext.getActionContext().getSessionMap();
        if (this.shippingAddressRequired) {
            this.shippingAddressRequired = false;
            return "shipping";
        }
        if (!this.isConfirmed()) {
            return "confirm";
        }
        if (this.getOrder() != null) {
            orderService.insertOrder(this.order);
            CartBean cartBean = (CartBean)sessionMap.get("cartBean");
            cartBean.clear();
            ActionContext.getActionContext().setSimpleMessage("Thank you, your order has been submitted.");
            return "success";
        }
        ActionContext.getActionContext().setSimpleMessage("An error occurred processing your order (order was null).");
        return "failure";
    }

    public String listOrders() {
        Map sessionMap = ActionContext.getActionContext().getSessionMap();
        AccountBean accountBean = (AccountBean)sessionMap.get("accountBean");
        this.orderList = orderService.getOrdersByUsername(accountBean.getAccount().getUsername());
        return "success";
    }

    public String switchOrderPage() {
        if ("next".equals(this.pageDirection)) {
            this.orderList.nextPage();
        } else if ("previous".equals(this.pageDirection)) {
            this.orderList.previousPage();
        }
        return "success";
    }

    public String viewOrder() {
        Map sessionMap = ActionContext.getActionContext().getSessionMap();
        AccountBean accountBean = (AccountBean)sessionMap.get("accountBean");
        this.order = orderService.getOrder(this.orderId);
        if (accountBean.getAccount().getUsername().equals(this.order.getUsername())) {
            return "success";
        }
        this.order = null;
        ActionContext.getActionContext().setSimpleMessage("You may only view your own orders.");
        return "failure";
    }

    public void reset() {
        this.shippingAddressRequired = false;
    }

    public void clear() {
        this.order = new Order();
        this.orderId = 0;
        this.shippingAddressRequired = false;
        this.confirmed = false;
        this.orderList = null;
        this.pageDirection = null;
    }

    public void validate() {
        ActionContext ctx = ActionContext.getActionContext();
        if (!this.isShippingAddressRequired()) {
            this.validateRequiredField(this.order.getCreditCard(), "FAKE (!) credit card number required.");
            this.validateRequiredField(this.order.getExpiryDate(), "Expiry date is required.");
            this.validateRequiredField(this.order.getCardType(), "Card type is required.");
            this.validateRequiredField(this.order.getShipToFirstName(), "Shipping Info: first name is required.");
            this.validateRequiredField(this.order.getShipToLastName(), "Shipping Info: last name is required.");
            this.validateRequiredField(this.order.getShipAddress1(), "Shipping Info: address is required.");
            this.validateRequiredField(this.order.getShipCity(), "Shipping Info: city is required.");
            this.validateRequiredField(this.order.getShipState(), "Shipping Info: state is required.");
            this.validateRequiredField(this.order.getShipZip(), "Shipping Info: zip/postal code is required.");
            this.validateRequiredField(this.order.getShipCountry(), "Shipping Info: country is required.");
            this.validateRequiredField(this.order.getBillToFirstName(), "Billing Info: first name is required.");
            this.validateRequiredField(this.order.getBillToLastName(), "Billing Info: last name is required.");
            this.validateRequiredField(this.order.getBillAddress1(), "Billing Info: address is required.");
            this.validateRequiredField(this.order.getBillCity(), "Billing Info: city is required.");
            this.validateRequiredField(this.order.getBillState(), "Billing Info: state is required.");
            this.validateRequiredField(this.order.getBillZip(), "Billing Info: zip/postal code is required.");
            this.validateRequiredField(this.order.getBillCountry(), "Billing Info: country is required.");
        }
        if (ctx.isSimpleErrorsExist()) {
            this.order.setBillAddress1(this.order.getShipAddress1());
            this.order.setBillAddress2(this.order.getShipAddress2());
            this.order.setBillToFirstName(this.order.getShipToFirstName());
            this.order.setBillToLastName(this.order.getShipToLastName());
            this.order.setBillCity(this.order.getShipCity());
            this.order.setBillCountry(this.order.getShipCountry());
            this.order.setBillState(this.order.getShipState());
            this.order.setBillZip(this.order.getShipZip());
        }
    }

    static {
        ArrayList<String> cardList = new ArrayList<String>();
        cardList.add("Visa");
        cardList.add("MasterCard");
        cardList.add("American Express");
        CARD_TYPE_LIST = Collections.unmodifiableList(cardList);
    }
}

