/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.portlets.prm.model;

import java.util.Locale;
import org.apache.jetspeed.om.portlet.Description;
import org.apache.jetspeed.om.portlet.InitParam;
import org.apache.jetspeed.om.portlet.PortletApplication;
import org.apache.jetspeed.om.portlet.PortletDefinition;
import org.apache.jetspeed.om.portlet.SecurityRoleRef;
import org.apache.jetspeed.om.portlet.UserAttribute;
import org.apache.jetspeed.portlets.JetspeedServiceLocator;
import org.apache.jetspeed.portlets.prm.DescriptionBean;
import org.apache.jetspeed.portlets.prm.PortletApplicationNodeBean;
import org.apache.jetspeed.portlets.util.PortletApplicationUtils;
import org.apache.wicket.model.LoadableDetachableModel;

public class DescriptionBeanModel
extends LoadableDetachableModel<DescriptionBean> {
    private static final long serialVersionUID = 1L;
    private JetspeedServiceLocator locator;
    private PortletApplicationNodeBean paNodeBean;
    private Class type;
    private String name;
    private Locale locale;

    public DescriptionBeanModel(JetspeedServiceLocator locator, PortletApplicationNodeBean paNodeBean, Class type, String name, DescriptionBean descriptionBean) {
        super((Object)descriptionBean);
        this.locator = locator;
        this.paNodeBean = paNodeBean;
        this.type = type;
        this.name = name;
        this.locale = descriptionBean.getLocale();
    }

    protected DescriptionBean load() {
        Description description = null;
        PortletApplication app = this.locator.getPortletRegistry().getPortletApplication(this.paNodeBean.getApplicationName());
        PortletDefinition def = null;
        if (this.paNodeBean.getName() != null) {
            def = PortletApplicationUtils.getPortletOrClone((PortletApplication)app, (String)this.paNodeBean.getName());
        }
        if (def != null) {
            if (this.type == InitParam.class) {
                InitParam param = def.getInitParam(this.name);
                description = param.getDescription(this.locale);
            } else if (this.type == SecurityRoleRef.class) {
                SecurityRoleRef securityRoleRef = def.getSecurityRoleRef(this.name);
                description = securityRoleRef.getDescription(this.locale);
            }
        } else {
            UserAttribute attr = app.getUserAttribute(this.name);
            description = attr.getDescription(this.locale);
        }
        return new DescriptionBean(description);
    }
}

