/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.portlets.spaces;

import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletContext;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import org.apache.jetspeed.administration.PortalAdministration;
import org.apache.jetspeed.decoration.DecorationFactory;
import org.apache.jetspeed.om.folder.Folder;
import org.apache.jetspeed.om.page.SecurityConstraintsDef;
import org.apache.jetspeed.page.PageManager;
import org.apache.jetspeed.portlets.spaces.SpaceAdminUtils;
import org.apache.jetspeed.portlets.spaces.SpaceBean;
import org.apache.jetspeed.portlets.toolbox.ThemeBean;
import org.apache.jetspeed.security.UserManager;
import org.apache.jetspeed.spaces.Space;
import org.apache.jetspeed.spaces.Spaces;
import org.apache.portals.bridges.common.GenericServletPortlet;
import org.apache.portals.messaging.PortletMessaging;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpacesManager
extends GenericServletPortlet {
    public static final String MSG_TOPIC_SPACE_LIST = "SpaceList";
    public static final String MSG_TOPIC_SPACE_NAV = "SpaceNavigator";
    public static final String MSG_TOPIC_PAGE_NAV = "PageNavigator";
    public static final String MSG_SPACE_CHANGE = "spaceChange";
    private static final String DEFAULT_SPACE_TEMPLATE = "/_template/space";
    private static final String SPACE_TEMPLATE = "spaceTemplate";
    private static Logger log = LoggerFactory.getLogger(SpacesManager.class);
    protected PageManager pageManager;
    private PortalAdministration admin;
    private UserManager userManager;
    private Spaces spacesService;
    protected DecorationFactory decorationFactory;

    public void init(PortletConfig config) throws PortletException {
        super.init(config);
        PortletContext context = this.getPortletContext();
        this.spacesService = (Spaces)context.getAttribute("cps:SpacesService");
        if (this.spacesService == null) {
            throw new PortletException("Could not get instance of portal spaces service component");
        }
        this.admin = (PortalAdministration)context.getAttribute("cps:PortalAdministration");
        if (this.admin == null) {
            throw new PortletException("Failed to find the Portal Administration on portlet initialization");
        }
        this.pageManager = (PageManager)context.getAttribute("cps:PageManager");
        if (this.pageManager == null) {
            throw new PortletException("Failed to find the Page Manager on portlet initialization");
        }
        this.userManager = (UserManager)context.getAttribute("cps:UserManager");
        if (null == this.userManager) {
            throw new PortletException("Failed to find the user manager on portlet initialization");
        }
        this.decorationFactory = (DecorationFactory)context.getAttribute("cps:DecorationFactory");
        if (null == this.decorationFactory) {
            throw new PortletException("Failed to find the Decoration Factory on portlet initialization");
        }
    }

    public void doView(RenderRequest request, RenderResponse response) throws PortletException, IOException {
        Space space = null;
        SpaceBean spaceBean = null;
        String current = (String)PortletMessaging.receive((PortletRequest)request, (String)MSG_TOPIC_SPACE_LIST, (String)MSG_SPACE_CHANGE);
        if (current != null && (space = this.spacesService.lookupSpace(current)) == null) {
            space = this.spacesService.lookupUserSpace(current);
        }
        if (space != null) {
            spaceBean = new SpaceBean(space);
        } else {
            spaceBean = new SpaceBean("", "");
            spaceBean.setDescription("");
            spaceBean.setTitle("");
            spaceBean.setSecurityConstraint("");
            spaceBean.setTheme(ThemeBean.getDefaultTheme((PortletRequest)request, (DecorationFactory)this.decorationFactory));
        }
        request.setAttribute("constraints", (Object)this.retrieveConstraints(request));
        request.setAttribute("themes", (Object)ThemeBean.retrieveThemes((PortletRequest)request, (DecorationFactory)this.decorationFactory, (String)spaceBean.getTheme()));
        request.setAttribute("space", (Object)spaceBean);
        if (SpaceAdminUtils.isUserSpaceOwner((SpaceBean)spaceBean, (PortletRequest)request) || SpaceAdminUtils.isUserSpaceAdmin((SpaceBean)spaceBean, (PortalAdministration)this.admin, (PortletRequest)request)) {
            request.setAttribute("spaceEditable", (Object)Boolean.TRUE);
        }
        if (SpaceAdminUtils.isUserSpaceAdmin((SpaceBean)spaceBean, (PortalAdministration)this.admin, (PortletRequest)request)) {
            request.setAttribute("spaceCreatable", (Object)Boolean.TRUE);
        }
        super.doView(request, response);
    }

    protected List<String> retrieveConstraints(RenderRequest request) throws PortletException {
        Iterator i;
        LinkedList<String> result = (LinkedList<String>)request.getPortletSession().getAttribute("constraints");
        if (result != null) {
            return result;
        }
        result = new LinkedList<String>();
        result.add("");
        try {
            i = this.pageManager.getPageSecurity().getSecurityConstraintsDefs().iterator();
        }
        catch (Exception e) {
            throw new PortletException((Throwable)e);
        }
        while (i.hasNext()) {
            SecurityConstraintsDef def = (SecurityConstraintsDef)i.next();
            result.add(def.getName());
        }
        request.getPortletSession().setAttribute("constraints", result);
        return result;
    }

    public void processAction(ActionRequest actionRequest, ActionResponse actionResponse) throws PortletException, IOException {
        boolean isCanceled = actionRequest.getParameter("cancelAction") != null;
        String persisted = this.scrapeParameter(actionRequest, "spacePersisted");
        boolean isNew = persisted == null || persisted.equals("0") || persisted.equalsIgnoreCase("false");
        String name = this.scrapeParameter(actionRequest, "spaceName");
        String title = this.scrapeParameter(actionRequest, "spaceTitle");
        if (title == null || "".equals(title.trim())) {
            title = name;
        }
        String description = this.scrapeParameter(actionRequest, "spaceDescription");
        String theme = this.scrapeParameter(actionRequest, "theme");
        String constraint = this.scrapeParameter(actionRequest, "securityConstraintRef");
        if (isCanceled) {
            try {
                Space space = null;
                if (!"".equals(name) && (space = this.spacesService.lookupSpace(name)) == null) {
                    space = this.spacesService.lookupUserSpace(name);
                }
                String path = this.admin.getPortalURL((PortletRequest)actionRequest, (PortletResponse)actionResponse, space != null ? space.getPath() : "/");
                actionResponse.sendRedirect(path);
                return;
            }
            catch (Exception e) {
                log.error("Failed to retrieve space.", (Throwable)e);
            }
        }
        if ("".equals(name)) {
            return;
        }
        try {
            if (isNew) {
                String spaceName = name.replace(' ', '_');
                String templateFolderPath = actionRequest.getPreferences().getValue(SPACE_TEMPLATE, DEFAULT_SPACE_TEMPLATE);
                if (!this.pageManager.folderExists(templateFolderPath)) {
                    throw new PortletException("Space template folder does not exist: " + templateFolderPath);
                }
                Folder templateFolder = this.pageManager.getFolder(templateFolderPath);
                String owner = actionRequest.getUserPrincipal().getName();
                try {
                    this.userManager.getUser(owner);
                }
                catch (SecurityException notFoundEx) {
                    throw new PortletException("Space owner is not found: " + owner);
                }
                Space space = this.spacesService.createSpace(spaceName, owner, templateFolder, title, title, description, theme, constraint);
                String path = this.admin.getPortalURL((PortletRequest)actionRequest, (PortletResponse)actionResponse, space.getPath());
                actionResponse.sendRedirect(path);
            } else {
                String owner = this.scrapeParameter(actionRequest, "spaceOwner");
                Space space = this.spacesService.lookupSpace(name);
                if (space == null) {
                    space = this.spacesService.lookupUserSpace(name);
                }
                if (space != null) {
                    space.setDescription(description);
                    space.setTitle(title);
                    space.setShortTitle(title);
                    space.setTheme(theme);
                    if (constraint.equals("")) {
                        String old = space.getSecurityConstraint();
                        if (old != null && !"".equals(old)) {
                            space.setSecurityConstraint(constraint);
                        }
                    } else {
                        space.setSecurityConstraint(constraint);
                    }
                    if (owner != null && !owner.equals(space.getOwner())) {
                        try {
                            this.userManager.getUser(owner);
                        }
                        catch (SecurityException notFoundEx) {
                            throw new PortletException("Space owner is not found: " + owner);
                        }
                        space.setOwner(owner);
                    }
                    this.spacesService.storeSpace(space);
                }
                String path = this.admin.getPortalURL((PortletRequest)actionRequest, (PortletResponse)actionResponse, space.getPath());
                actionResponse.sendRedirect(path);
            }
            PortletMessaging.publish((PortletRequest)actionRequest, (String)MSG_TOPIC_SPACE_LIST, (String)MSG_SPACE_CHANGE, (Object)name);
            PortletMessaging.publish((PortletRequest)actionRequest, (String)MSG_TOPIC_SPACE_NAV, (String)MSG_SPACE_CHANGE, (Object)name);
            PortletMessaging.publish((PortletRequest)actionRequest, (String)MSG_TOPIC_PAGE_NAV, (String)MSG_SPACE_CHANGE, (Object)name);
            actionRequest.getPortletSession().removeAttribute("spaces", 1);
            actionRequest.getPortletSession().removeAttribute("space", 1);
        }
        catch (Exception e) {
            log.error("Failed to save space.", (Throwable)e);
        }
    }

    private String scrapeParameter(ActionRequest request, String paramName) {
        String param = request.getParameter(paramName);
        if (param == null) {
            param = "";
        }
        param = param.trim();
        return param;
    }
}

