/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.portlets.sso;

import java.io.IOException;
import java.util.List;
import javax.portlet.PortletConfig;
import javax.portlet.PortletException;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import org.apache.jetspeed.portlets.sso.JetspeedSSOUtils;
import org.apache.jetspeed.sso.SSOManager;
import org.apache.portals.applications.webcontent2.portlet.IFrameGenericPortlet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SSOReverseProxyIFramePortlet
extends IFrameGenericPortlet {
    public static final String SUBJECT_SSO_SITE_CREDS = "org.apache.jetspeed.portlets.sso.ssoSiteCredsOfSubject";
    private static Logger log = LoggerFactory.getLogger(SSOReverseProxyIFramePortlet.class);
    private SSOManager ssoManager;

    public void init(PortletConfig config) throws PortletException {
        super.init(config);
        this.ssoManager = (SSOManager)config.getPortletContext().getAttribute("cps:SSO");
        if (null == this.ssoManager) {
            throw new PortletException("Failed to find SSO Provider on portlet initialization");
        }
    }

    public void doView(RenderRequest request, RenderResponse response) throws PortletException, IOException {
        List ssoCredsList = JetspeedSSOUtils.getSubjectSSOSiteCredentials((SSOManager)this.ssoManager);
        if (ssoCredsList.isEmpty()) {
            String warningMessage = this.getResourceBundle(request.getLocale()).getString("no.credentials");
            response.getWriter().print(warningMessage);
            return;
        }
        request.getPortletSession().setAttribute(SUBJECT_SSO_SITE_CREDS, (Object)ssoCredsList, 1);
        super.doView(request, response);
    }
}

