/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.portlets.toolbox;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletContext;
import javax.portlet.PortletException;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.jetspeed.JetspeedActions;
import org.apache.jetspeed.administration.PortalAdministration;
import org.apache.jetspeed.decoration.DecorationFactory;
import org.apache.jetspeed.layout.PageLayoutComponent;
import org.apache.jetspeed.om.page.ContentFragment;
import org.apache.jetspeed.om.page.ContentPage;
import org.apache.jetspeed.portlets.toolbox.LayoutBean;
import org.apache.jetspeed.portlets.toolbox.ThemeBean;
import org.apache.jetspeed.request.RequestContext;
import org.apache.portals.bridges.common.GenericServletPortlet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;

public class JetspeedToolbox
extends GenericServletPortlet {
    static Logger log = LoggerFactory.getLogger(JetspeedToolbox.class);
    protected PortalAdministration portalAdministration;
    protected PageLayoutComponent pageLayoutComponent;
    protected DecorationFactory decorationFactory;
    protected String yuiScriptPath = "/javascript/yui/build/yui/yui-min.js";

    public void init(PortletConfig config) throws PortletException {
        super.init(config);
        PortletContext context = this.getPortletContext();
        this.portalAdministration = (PortalAdministration)this.getPortletContext().getAttribute("cps:PortalAdministration");
        this.pageLayoutComponent = (PageLayoutComponent)context.getAttribute("cps:PageLayoutComponent");
        if (this.pageLayoutComponent == null) {
            throw new PortletException("Failed to find the Page Layout Component on portlet initialization");
        }
        this.decorationFactory = (DecorationFactory)context.getAttribute("cps:DecorationFactory");
        if (this.decorationFactory == null) {
            throw new PortletException("Failed to find the Decoration Factory on portlet initialization");
        }
        String param = config.getInitParameter("yuiScriptPath");
        if (param != null) {
            this.yuiScriptPath = param;
        }
    }

    protected void doHeaders(RenderRequest request, RenderResponse response) {
        super.doHeaders(request, response);
        RequestContext rc = (RequestContext)request.getAttribute("org.apache.jetspeed.request.RequestContext");
        Element headElem = response.createElement("script");
        headElem.setAttribute("language", "javascript");
        String scriptPath = rc.getRequest().getContextPath() + this.yuiScriptPath;
        headElem.setAttribute("id", "header.yui.library.include");
        headElem.setAttribute("src", scriptPath);
        headElem.setAttribute("type", "text/javascript");
        response.addProperty("javax.portlet.markup.head.element", headElem);
    }

    public void doView(RenderRequest request, RenderResponse response) throws PortletException, IOException {
        request.setAttribute("defaultCategory", (Object)this.getDefaultCategory((PortletRequest)request, ""));
        List categories = this.retrieveCategories((PortletRequest)request);
        request.setAttribute("categories", (Object)categories);
        Map categoryKeywordsMap = this.retrieveCategoryKeywordsMap(categories, (PortletRequest)request);
        request.setAttribute("categoryKeywords", (Object)categoryKeywordsMap);
        request.setAttribute("layouts", (Object)LayoutBean.retrieveLayouts((PortletRequest)request, (DecorationFactory)this.decorationFactory));
        request.setAttribute("themes", (Object)ThemeBean.retrieveThemes((PortletRequest)request, (DecorationFactory)this.decorationFactory));
        PortletPreferences prefs = request.getPreferences();
        request.setAttribute("prefs", (Object)prefs.getMap());
        boolean userInAdminRole = this.portalAdministration.isUserInAdminRole((PortletRequest)request);
        request.setAttribute("userInAdminRole", (Object)(userInAdminRole ? Boolean.TRUE : Boolean.FALSE));
        boolean hasEditAccess = false;
        try {
            RequestContext requestContext = (RequestContext)request.getAttribute("org.apache.jetspeed.request.RequestContext");
            ContentPage contentPage = requestContext.getPage();
            contentPage.checkAccess(JetspeedActions.EDIT);
            hasEditAccess = true;
        }
        catch (Exception ignore) {
            // empty catch block
        }
        request.setAttribute("editAccess", (Object)(hasEditAccess ? Boolean.TRUE : Boolean.FALSE));
        super.doView(request, response);
    }

    public void processAction(ActionRequest actionRequest, ActionResponse actionResponse) throws PortletException, IOException {
        String theme = actionRequest.getParameter("theme");
        String layout = actionRequest.getParameter("layout");
        RequestContext requestContext = (RequestContext)actionRequest.getAttribute("org.apache.jetspeed.request.RequestContext");
        if (theme != null) {
            try {
                ContentPage page = requestContext.getPage();
                this.pageLayoutComponent.updateDefaultDecorator(page, theme, "layout");
                this.pageLayoutComponent.updateDefaultDecorator(page, theme, "layout");
                actionRequest.getPortletSession().removeAttribute("themes");
            }
            catch (Exception e) {
                log.error("Page has not been updated.", (Throwable)e);
            }
        }
        if (layout != null) {
            try {
                ContentFragment layoutFragment = requestContext.getPage().getNonTemplateRootFragment();
                this.pageLayoutComponent.updateName(layoutFragment, layout);
                actionRequest.getPortletSession().removeAttribute("layouts");
            }
            catch (Exception e) {
                log.error("Page has not been updated.", (Throwable)e);
            }
        }
    }

    protected String getDefaultCategory(PortletRequest request, String defaultValue) throws PortletException {
        return request.getPreferences().getValue("DefaultCategory", defaultValue);
    }

    protected List<String> retrieveCategories(PortletRequest request) throws PortletException {
        List<String> categories = (List<String>)request.getPortletSession().getAttribute("categories");
        if (categories != null) {
            return categories;
        }
        String cats = request.getPreferences().getValue("Categories", null);
        if (cats == null) {
            throw new PortletException("No categories defined, please add categories via edit mode.");
        }
        categories = Arrays.asList(StringUtils.split((String)cats, (String)", \t\r\n"));
        request.getPortletSession().setAttribute("categories", categories);
        return categories;
    }

    protected Map<String, String> retrieveCategoryKeywordsMap(List<String> categories, PortletRequest request) throws PortletException {
        HashMap<String, String> keywordsMap = new HashMap<String, String>();
        PortletPreferences prefs = request.getPreferences();
        for (String category : categories) {
            String keywords = prefs.getValue("Keywords:" + category, "");
            keywordsMap.put(category, keywords);
        }
        return keywordsMap;
    }
}

