/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.jetapp;

import java.io.IOException;
import javax.portlet.PortletException;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.filter.FilterChain;
import javax.portlet.filter.FilterConfig;
import javax.portlet.filter.RenderFilter;
import javax.servlet.http.HttpServletRequest;
import org.apache.jetspeed.jetapp.JetAppPortlet;

public class JetAppPortletFilter
implements RenderFilter {
    protected static final String JET_DASHBOARD_ANGULAR_FLAG = "jet.dashboard.angular.flag";
    protected FilterConfig filterConfig = null;
    protected final String ANGULAR = "<script>\n    angular.element(document).ready(function() {\n        angular.bootstrap(document, ['j2admin']);\n    });\n</script>\n";

    public void doFilter(RenderRequest request, RenderResponse response, FilterChain filterChain) throws IOException, PortletException {
        filterChain.doFilter(request, response);
        this.includeAngular(request, response);
    }

    public void destroy() {
    }

    public void init(FilterConfig filterConfig) throws PortletException {
        this.filterConfig = filterConfig;
    }

    protected void includeAngular(RenderRequest request, RenderResponse response) throws PortletException, IOException {
        String useAngular = request.getPreferences().getValue("jetapp", null);
        if (useAngular != null && useAngular.equalsIgnoreCase("true") && !this.alreadyContributedAngular(request)) {
            response.getWriter().flush();
            response.getPortletOutputStream().write("<script>\n    angular.element(document).ready(function() {\n        angular.bootstrap(document, ['j2admin']);\n    });\n</script>\n".getBytes());
        }
    }

    protected boolean alreadyContributedAngular(RenderRequest renderRequest) {
        HttpServletRequest request = JetAppPortlet.getServletRequest((RenderRequest)renderRequest);
        if (request == null) {
            return false;
        }
        Boolean contributed = (Boolean)request.getAttribute(JET_DASHBOARD_ANGULAR_FLAG);
        if (contributed == null || !contributed.booleanValue()) {
            request.setAttribute(JET_DASHBOARD_ANGULAR_FLAG, (Object)Boolean.TRUE);
            return false;
        }
        return true;
    }
}

