/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.jetapp;

import java.io.IOException;
import javax.portlet.PortletException;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.servlet.http.Cookie;
import org.apache.jetspeed.jetapp.JetAppAuthResult;
import org.apache.jetspeed.jetapp.JetAppCredentials;
import org.apache.jetspeed.jetapp.JetAppPortlet;
import org.apache.jetspeed.jetapp.RestAuthClient;

public class JetAppTokenPortlet
extends JetAppPortlet {
    protected static final String MSG_MISSING_REST_SERVICE_PARAM = "<b>Missing initialization parameter. Cannot connect to API Server - missing param: %s</b>";
    protected static final String MISSING_INIT_PARAMETER = "Missing initialization parameter for app: ";
    protected static final String SESSION_JETAPP_TOKEN = "JetAppToken";
    protected static final String JET_APP_NAME = "j2-admin";
    protected static final String COOKIE_JETAPP_TOKEN = "JetAppToken";
    protected static final String COOKIE_JETAPP_REST_SERVICE = "JetAppRestService";
    protected static final String MSG_FAILED_AUTHENTICATE = "<b>Failed to authenticate. Cannot connect to API Server</b>";

    protected JetAppCredentials getCredentials() {
        return new JetAppCredentials("user", "user", "http://localhost/services", JET_APP_NAME);
    }

    protected boolean authenticate(RenderRequest request, RenderResponse response) throws PortletException, IOException {
        String token = (String)request.getPortletSession(true).getAttribute("JetAppToken");
        if (token == null) {
            JetAppCredentials credentials = this.getCredentials();
            Cookie restCookie = new Cookie(COOKIE_JETAPP_REST_SERVICE, credentials.getEndpoint());
            restCookie.setPath("/");
            response.addProperty(restCookie);
            try {
                RestAuthClient client = new RestAuthClient(credentials);
                JetAppAuthResult result = client.login();
                if (result.isSuccess()) {
                    token = result.getToken();
                    Cookie tokenCookie = new Cookie("JetAppToken", token);
                    tokenCookie.setPath("/");
                    response.addProperty(tokenCookie);
                    request.getPortletSession().setAttribute("JetAppToken", (Object)token);
                    return true;
                }
                log.error((Object)"Failed authentication in for app: j2-admin");
                response.getWriter().println(MSG_FAILED_AUTHENTICATE);
                return false;
            }
            catch (Exception e) {
                log.error((Object)("Exception during authentication in Dashboard: " + e.getMessage()), (Throwable)e);
                response.getWriter().println(MSG_FAILED_AUTHENTICATE);
                return false;
            }
        }
        return true;
    }
}

