/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.portlets.prm;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.jetspeed.om.portlet.PortletApplication;
import org.apache.jetspeed.portlets.JetspeedServiceLocator;
import org.apache.jetspeed.portlets.prm.ApplicationBean;
import org.apache.jetspeed.portlets.prm.ApplicationDataProvider;
import org.apache.jetspeed.search.ParsedObject;
import org.apache.jetspeed.search.SearchResults;
import org.apache.wicket.extensions.markup.html.repeater.util.SortableDataProvider;
import org.apache.wicket.markup.repeater.data.IDataProvider;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApplicationDataProvider
extends SortableDataProvider<ApplicationBean>
implements IDataProvider<ApplicationBean> {
    private JetspeedServiceLocator serviceLocator;
    private boolean searchMode = false;
    private List<ApplicationBean> portletApps = null;
    private List<ApplicationBean> searchResults = null;
    private AppOrderBy orderBy = AppOrderBy.NAME_ASC;
    private static final long serialVersionUID = 1L;
    private static final Logger log = LoggerFactory.getLogger(ApplicationDataProvider.class);

    public ApplicationDataProvider(JetspeedServiceLocator locator) {
        this.serviceLocator = locator;
        this.setSort("name", true);
        this.refresh();
    }

    public Iterator<ApplicationBean> iterator(int first, int count) {
        int last = first + count;
        if (last > this.portletApps.size()) {
            last = this.portletApps.size() - 1;
        }
        if (last < 0) {
            last = 0;
        }
        return this.portletApps.subList(first, last).iterator();
    }

    public int size() {
        if (this.searchMode) {
            if (this.searchResults == null) {
                return 0;
            }
            return this.searchResults.size();
        }
        if (this.portletApps == null) {
            return 0;
        }
        return this.portletApps.size();
    }

    public void detach() {
        super.detach();
    }

    public void refresh() {
        if (this.searchMode) {
            if (this.searchResults != null) {
                this.portletApps = this.searchResults;
                return;
            }
            this.searchMode = false;
        } else {
            this.portletApps = new ArrayList();
            Collection apps = this.serviceLocator.getPortletRegistry().getPortletApplications();
            for (PortletApplication app : apps) {
                boolean isRunning = this.serviceLocator.getPortletFactory().isPortletApplicationRegistered(app);
                this.portletApps.add(new ApplicationBean(app, isRunning));
            }
            this.sort(this.portletApps, this.orderBy);
        }
    }

    public void setSearchMode(boolean mode) {
        this.searchMode = mode;
    }

    public boolean getSearchMode() {
        return this.searchMode;
    }

    public void searchApplications(String search) {
        try {
            if (search == null) {
                this.searchMode = false;
                return;
            }
            this.searchResults = new ArrayList();
            SearchResults results = this.serviceLocator.getSearchEngine().search(search);
            if (results.size() > 0) {
                for (ParsedObject po : results.getResults()) {
                    PortletApplication pa;
                    String paName;
                    Map fields = po.getFields();
                    if (fields == null || !po.getType().equals("portlet_application")) continue;
                    Object id = fields.get("ID");
                    if (id instanceof Collection) {
                        Collection coll = (Collection)id;
                        paName = (String)coll.iterator().next();
                    } else {
                        paName = (String)id;
                    }
                    if ((pa = this.serviceLocator.getPortletRegistry().getPortletApplication(paName)) == null) continue;
                    boolean isRunning = this.serviceLocator.getPortletFactory().isPortletApplicationRegistered(pa);
                    this.searchResults.add(new ApplicationBean(pa, isRunning));
                }
            }
            this.searchMode = true;
            this.sort(this.searchResults, this.orderBy);
            this.refresh();
        }
        catch (Exception e) {
            log.error("Registry Search failure: ", (Throwable)e);
        }
    }

    public void sort(List<ApplicationBean> list, AppOrderBy orderBy) {
        Collections.sort(list, new AppComparator(this, orderBy));
    }

    public void sort() {
        this.sort(this.portletApps, this.orderBy);
    }

    public IModel<ApplicationBean> model(ApplicationBean object) {
        return new Model((Serializable)object);
    }

    public AppOrderBy getOrderBy() {
        return this.orderBy;
    }

    public void setOrderBy(AppOrderBy orderBy) {
        this.orderBy = orderBy;
    }
}

