/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.portlets.prm.application;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import org.apache.commons.lang.StringUtils;
import org.apache.jetspeed.om.page.SecurityConstraintsDef;
import org.apache.jetspeed.om.portlet.Description;
import org.apache.jetspeed.om.portlet.PortletApplication;
import org.apache.jetspeed.page.PageManager;
import org.apache.jetspeed.portlets.JetspeedServiceLocator;
import org.apache.jetspeed.portlets.prm.KeyVal;
import org.apache.jetspeed.portlets.prm.PortletApplicationNodeBean;
import org.apache.jetspeed.portlets.prm.application.DetailsPanel;
import org.apache.jetspeed.portlets.wicket.AbstractAdminWebApplication;
import org.apache.jetspeed.portlets.wicket.component.JavascriptEventConfirmation;
import org.apache.wicket.Component;
import org.apache.wicket.behavior.IBehavior;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.DropDownChoice;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.model.ResourceModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DetailsPanel
extends Panel {
    private static final long serialVersionUID = 1L;
    static final Logger logger = LoggerFactory.getLogger(DetailsPanel.class);
    private transient List<KeyVal> detailList = new ArrayList();
    private String jetspeedSecurityConstraint;
    private List<String> jetspeedSecurityContraintNames;

    public DetailsPanel(String id, PortletApplicationNodeBean paNodeBean) {
        super(id);
        JetspeedServiceLocator locator = ((AbstractAdminWebApplication)this.getApplication()).getServiceLocator();
        PortletApplication app = locator.getPortletRegistry().getPortletApplication(paNodeBean.getApplicationName());
        this.detailList.add(new KeyVal("Name", app.getName()));
        this.detailList.add(new KeyVal("Version", app.getVersion()));
        this.detailList.add(new KeyVal("Description", this.getDescription(app)));
        this.detailList.add(new KeyVal("Type", this.getType(app)));
        this.detailList.add(new KeyVal("Services", new /* Unavailable Anonymous Inner Class!! */.toString(app.getJetspeedServices().iterator())));
        2 dataRepeater = new /* Unavailable Anonymous Inner Class!! */;
        this.jetspeedSecurityContraintNames = new ArrayList<String>(Arrays.asList(""));
        PageManager pageManager = ((AbstractAdminWebApplication)this.getApplication()).getServiceLocator().getPageManager();
        try {
            for (Object secConstDefObj : pageManager.getPageSecurity().getSecurityConstraintsDefs()) {
                SecurityConstraintsDef secConstDef = (SecurityConstraintsDef)secConstDefObj;
                this.jetspeedSecurityContraintNames.add(secConstDef.getName());
            }
        }
        catch (Exception e) {
            logger.error("Failed to retrieve jetspeed security constraint defs from page manager.", (Throwable)e);
        }
        this.jetspeedSecurityConstraint = app.getJetspeedSecurityConstraint();
        Form form = new Form("form");
        form.add(new Component[]{dataRepeater});
        form.add(new Component[]{new DropDownChoice("jetspeedConstraint", (IModel)new PropertyModel((Object)this, "jetspeedSecurityConstraint"), this.jetspeedSecurityContraintNames)});
        form.add(new Component[]{new /* Unavailable Anonymous Inner Class!! */});
        form.add(new Component[]{new Label("resourceBundle", app.getResourceBundle())});
        4 reloadResourceBundlesButton = new /* Unavailable Anonymous Inner Class!! */;
        reloadResourceBundlesButton.add(new IBehavior[]{new JavascriptEventConfirmation("onclick", (IModel)new ResourceModel("pam.details.resource.bundle.reload.confirm"))});
        reloadResourceBundlesButton.setEnabled(!StringUtils.isBlank((String)app.getResourceBundle()));
        form.add(new Component[]{reloadResourceBundlesButton});
        5 refreshSearchIndexButton = new /* Unavailable Anonymous Inner Class!! */;
        refreshSearchIndexButton.add(new IBehavior[]{new JavascriptEventConfirmation("onclick", (IModel)new ResourceModel("pam.details.search.index.refresh.confirm"))});
        refreshSearchIndexButton.setEnabled(true);
        form.add(new Component[]{refreshSearchIndexButton});
        this.add(new Component[]{form});
    }

    private String getDescription(PortletApplication app) {
        Description desc = app.getDescription(new Locale("en"));
        if (desc == null) {
            return null;
        }
        return desc.getDescription();
    }

    private String getType(PortletApplication pa) {
        int type = pa.getApplicationType();
        if (type == 1) {
            return "local";
        }
        if (type == 0) {
            return "webapp";
        }
        return "unknown";
    }

    static /* synthetic */ String access$000(DetailsPanel x0) {
        return x0.jetspeedSecurityConstraint;
    }
}

