/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.portlets.prm.portlet;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.apache.jetspeed.components.portletregistry.PortletRegistry;
import org.apache.jetspeed.components.portletregistry.RegistryException;
import org.apache.jetspeed.om.page.SecurityConstraintsDef;
import org.apache.jetspeed.om.portlet.PortletApplication;
import org.apache.jetspeed.om.portlet.PortletDefinition;
import org.apache.jetspeed.om.portlet.SecurityRoleRef;
import org.apache.jetspeed.page.PageManager;
import org.apache.jetspeed.portlets.JetspeedServiceLocator;
import org.apache.jetspeed.portlets.prm.PortletApplicationNodeBean;
import org.apache.jetspeed.portlets.prm.model.SecurityRoleRefModel;
import org.apache.jetspeed.portlets.util.PortletApplicationUtils;
import org.apache.jetspeed.portlets.wicket.AbstractAdminWebApplication;
import org.apache.jetspeed.portlets.wicket.component.editor.EditorTemplate;
import org.apache.wicket.Component;
import org.apache.wicket.markup.html.form.Button;
import org.apache.wicket.markup.html.form.DropDownChoice;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.markup.html.panel.FeedbackPanel;
import org.apache.wicket.markup.html.panel.Fragment;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.model.StringResourceModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SecurityPanel
extends EditorTemplate<SecurityRoleRef> {
    private static final long serialVersionUID = 1L;
    static final Logger logger = LoggerFactory.getLogger(SecurityPanel.class);
    private PortletApplicationNodeBean paNodeBean;
    private String newRoleName;
    private String newRoleLink;
    private String newLocale;
    private String newDescription;
    private String jetspeedSecurityConstraint;
    private List<String> jetspeedSecurityContraintNames;

    public SecurityPanel(String id, PortletApplicationNodeBean paNodeBean) {
        super(id);
        this.paNodeBean = paNodeBean;
        EditorTemplate panel = this.initLayout();
        this.jetspeedSecurityContraintNames = new ArrayList<String>(Arrays.asList(""));
        PageManager pageManager = ((AbstractAdminWebApplication)this.getApplication()).getServiceLocator().getPageManager();
        try {
            for (Object secConstDefObj : pageManager.getPageSecurity().getSecurityConstraintsDefs()) {
                SecurityConstraintsDef secConstDef = (SecurityConstraintsDef)secConstDefObj;
                this.jetspeedSecurityContraintNames.add(secConstDef.getName());
            }
        }
        catch (Exception e) {
            logger.error("Failed to retrieve jetspeed security constraint defs from page manager.", (Throwable)e);
        }
        PortletRegistry registry = ((AbstractAdminWebApplication)this.getApplication()).getServiceLocator().getPortletRegistry();
        PortletApplication app = registry.getPortletApplication(paNodeBean.getApplicationName());
        PortletDefinition def = PortletApplicationUtils.getPortletOrClone((PortletApplication)app, (String)paNodeBean.getName());
        this.jetspeedSecurityConstraint = def.getJetspeedSecurityConstraint();
        Form form = (Form)panel.get("form");
        form.add(new Component[]{new DropDownChoice("jetspeedConstraint", (IModel)new PropertyModel((Object)this, "jetspeedSecurityConstraint"), this.jetspeedSecurityContraintNames)});
        form.add(new Component[]{new /* Unavailable Anonymous Inner Class!! */});
    }

    public String getJetspeedSecurityConstraint() {
        return this.jetspeedSecurityConstraint;
    }

    public void setJetspeedSecurityConstraint(String jetspeedSecurityConstraint) {
        this.jetspeedSecurityConstraint = jetspeedSecurityConstraint;
    }

    public void buildNew(Fragment fragment) {
        fragment.add(new Component[]{new TextField("newRoleName", (IModel)new PropertyModel((Object)this, "newRoleName"))});
        fragment.add(new Component[]{new TextField("newRoleLink", (IModel)new PropertyModel((Object)this, "newRoleLink"))});
        fragment.add(new Component[]{new TextField("newLocale", (IModel)new PropertyModel((Object)this, "newLocale"))});
        fragment.add(new Component[]{new TextField("newDescription", (IModel)new PropertyModel((Object)this, "newDescription"))});
    }

    public int getColumnCount() {
        return 3;
    }

    public void buildItems(Fragment fragment, SecurityRoleRef securityRoleRef) {
        JetspeedServiceLocator locator = ((AbstractAdminWebApplication)this.getApplication()).getServiceLocator();
        fragment.add(new Component[]{new TextField("roleName", (IModel)new PropertyModel((Object)new SecurityRoleRefModel(locator, this.paNodeBean, securityRoleRef), "roleName"))});
        fragment.add(new Component[]{new TextField("roleLink", (IModel)new PropertyModel((Object)new SecurityRoleRefModel(locator, this.paNodeBean, securityRoleRef), "roleLink"))});
        fragment.add(new Component[]{new /* Unavailable Anonymous Inner Class!! */});
    }

    public void delete(IModel<SecurityRoleRef>[] fields) {
        PortletRegistry registry = ((AbstractAdminWebApplication)this.getApplication()).getServiceLocator().getPortletRegistry();
        PortletApplication app = registry.getPortletApplication(this.paNodeBean.getApplicationName());
        PortletDefinition def = PortletApplicationUtils.getPortletOrClone((PortletApplication)app, (String)this.paNodeBean.getName());
        Iterator it = def.getSecurityRoleRefs().iterator();
        block2: while (it.hasNext()) {
            SecurityRoleRef securityRoleRef = (SecurityRoleRef)it.next();
            String roleName = securityRoleRef.getRoleName();
            for (IModel<SecurityRoleRef> field : fields) {
                if (!((SecurityRoleRef)field.getObject()).getRoleName().equals(roleName)) continue;
                it.remove();
                continue block2;
            }
        }
        FeedbackPanel feed = (FeedbackPanel)this.getPage().get("feedback");
        try {
            registry.savePortletDefinition(def);
            StringResourceModel resModel = new StringResourceModel("pam.details.action.status.portlet.saveOK", (Component)this, null, new Object[]{this.paNodeBean.getName()});
            feed.info(resModel.getString());
        }
        catch (RegistryException e) {
            logger.error("Failed to save portlet definition.", (Throwable)e);
            StringResourceModel resModel = new StringResourceModel("pam.details.action.status.portlet.saveFailure", (Component)this, null, new Object[]{this.paNodeBean.getName(), e.getMessage()});
            feed.info(resModel.getString());
        }
    }

    public Iterator<IModel<SecurityRoleRef>> getItemModels() {
        JetspeedServiceLocator locator = ((AbstractAdminWebApplication)this.getApplication()).getServiceLocator();
        PortletRegistry registry = locator.getPortletRegistry();
        PortletApplication app = registry.getPortletApplication(this.paNodeBean.getApplicationName());
        PortletDefinition def = PortletApplicationUtils.getPortletOrClone((PortletApplication)app, (String)this.paNodeBean.getName());
        ArrayList<SecurityRoleRefModel> securityRoleRefModels = new ArrayList<SecurityRoleRefModel>();
        for (SecurityRoleRef securityRoleRef : def.getSecurityRoleRefs()) {
            securityRoleRefModels.add(new SecurityRoleRefModel(locator, this.paNodeBean, securityRoleRef));
        }
        return securityRoleRefModels.iterator();
    }

    public IModel<SecurityRoleRef> getNewRowModel(SecurityRoleRef securityRoleRef) {
        JetspeedServiceLocator locator = ((AbstractAdminWebApplication)this.getApplication()).getServiceLocator();
        return new SecurityRoleRefModel(locator, this.paNodeBean, securityRoleRef);
    }

    protected Button saveButton(String componentId) {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    static /* synthetic */ String access$000(SecurityPanel x0) {
        return x0.jetspeedSecurityConstraint;
    }

    static /* synthetic */ PortletApplicationNodeBean access$1200(SecurityPanel x0) {
        return x0.paNodeBean;
    }

    static /* synthetic */ String access$1300(SecurityPanel x0) {
        return x0.newRoleName;
    }

    static /* synthetic */ String access$1400(SecurityPanel x0) {
        return x0.newRoleLink;
    }

    static /* synthetic */ String access$1500(SecurityPanel x0) {
        return x0.newLocale;
    }

    static /* synthetic */ String access$1600(SecurityPanel x0) {
        return x0.newDescription;
    }

    static /* synthetic */ String access$1302(SecurityPanel x0, String x1) {
        x0.newRoleName = x1;
        return x0.newRoleName;
    }

    static /* synthetic */ String access$1402(SecurityPanel x0, String x1) {
        x0.newRoleLink = x1;
        return x0.newRoleLink;
    }

    static /* synthetic */ String access$1502(SecurityPanel x0, String x1) {
        x0.newLocale = x1;
        return x0.newLocale;
    }

    static /* synthetic */ String access$1602(SecurityPanel x0, String x1) {
        x0.newDescription = x1;
        return x0.newDescription;
    }
}

