/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.portlets.search;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class PortletToPageMap
implements Serializable {
    private Map<String, List<String>> portletMap = new ConcurrentHashMap();
    private Map<String, List<String>> contentMap = new ConcurrentHashMap();

    public void putPortlet(String portlet, String pagePath) {
        ArrayList<String> pages = (ArrayList<String>)this.portletMap.get(portlet);
        if (pages == null) {
            pages = new ArrayList<String>();
            this.portletMap.put(portlet, pages);
        }
        pages.add(pagePath);
    }

    public void putContent(String contentPath, String pagePath) {
        ArrayList<String> pages = (ArrayList<String>)this.contentMap.get(contentPath);
        if (pages == null) {
            pages = new ArrayList<String>();
            this.contentMap.put(contentPath, pages);
        }
        pages.add(pagePath);
    }

    public List<String> getPortlet(String portlet) {
        return (List)this.portletMap.get(portlet);
    }

    public List<String> getContent(String portlet) {
        return (List)this.contentMap.get(portlet);
    }

    public int portletSize() {
        return this.portletMap.size();
    }

    public int contentSize() {
        return this.contentMap.size();
    }
}

