/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.portlets.security;

import java.io.IOException;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletContext;
import javax.portlet.PortletException;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import org.apache.jetspeed.JetspeedActions;
import org.apache.jetspeed.om.page.ContentPage;
import org.apache.jetspeed.request.RequestContext;
import org.apache.jetspeed.security.UserManager;
import org.apache.portals.bridges.common.GenericServletPortlet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;

public class JetspeedUserManagement2Portlet
extends GenericServletPortlet {
    static Logger log = LoggerFactory.getLogger(JetspeedUserManagement2Portlet.class);
    protected UserManager userManager;
    protected String yuiScriptPath = "/javascript/yui/build/yui/yui-min.js";

    public void init(PortletConfig config) throws PortletException {
        super.init(config);
        PortletContext context = this.getPortletContext();
        this.userManager = (UserManager)context.getAttribute("cps:UserManager");
        if (this.userManager == null) {
            throw new PortletException("Failed to find the User Manager Component on portlet initialization");
        }
        String param = config.getInitParameter("yuiScriptPath");
        if (param != null) {
            this.yuiScriptPath = param;
        }
    }

    protected void doHeaders(RenderRequest request, RenderResponse response) {
        super.doHeaders(request, response);
        RequestContext rc = (RequestContext)request.getAttribute("org.apache.jetspeed.request.RequestContext");
        this.addJavaScript(response, rc.getRequest().getContextPath() + this.yuiScriptPath, "header.yui.library.include");
        this.addJavaScript(response, request.getContextPath() + "/javascript/yui2/yui2-jetspeed.js", null);
        this.addStyleLink(response, request.getContextPath() + "/css/yui2/yui2-jetspeed.css", null);
        this.addStyleLink(response, request.getContextPath() + "/css/security-usermanager2.css", null);
    }

    public void doView(RenderRequest request, RenderResponse response) throws PortletException, IOException {
        boolean hasEditAccess = false;
        try {
            RequestContext requestContext = (RequestContext)request.getAttribute("org.apache.jetspeed.request.RequestContext");
            ContentPage contentPage = requestContext.getPage();
            contentPage.checkAccess(JetspeedActions.EDIT);
            hasEditAccess = true;
        }
        catch (Exception ignore) {
            // empty catch block
        }
        request.setAttribute("editAccess", (Object)(hasEditAccess ? Boolean.TRUE : Boolean.FALSE));
        super.doView(request, response);
    }

    public void processAction(ActionRequest actionRequest, ActionResponse actionResponse) throws PortletException, IOException {
    }

    private void addJavaScript(RenderResponse response, String scriptPath, String scriptId) {
        Element headElem = response.createElement("script");
        headElem.setAttribute("language", "javascript");
        if (scriptId != null) {
            headElem.setAttribute("id", scriptId);
        }
        headElem.setAttribute("src", scriptPath);
        headElem.setAttribute("type", "text/javascript");
        response.addProperty("javax.portlet.markup.head.element", headElem);
    }

    private void addStyleLink(RenderResponse response, String cssPath, String cssId) {
        Element headElem = response.createElement("link");
        headElem.setAttribute("rel", "stylesheet");
        if (cssId != null) {
            headElem.setAttribute("id", cssId);
        }
        headElem.setAttribute("href", cssPath);
        headElem.setAttribute("type", "text/css");
        response.addProperty("javax.portlet.markup.head.element", headElem);
    }
}

