/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.portlets.security;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.jetspeed.portlets.security.PrincipalDataProvider;
import org.apache.jetspeed.security.Group;
import org.apache.jetspeed.security.GroupManager;
import org.apache.jetspeed.security.JetspeedPrincipal;
import org.apache.jetspeed.security.JetspeedPrincipalManager;
import org.apache.jetspeed.security.Role;
import org.apache.jetspeed.security.RoleManager;
import org.apache.jetspeed.security.SecurityException;
import org.apache.jetspeed.security.UserSubjectPrincipal;
import org.apache.wicket.extensions.markup.html.repeater.util.SortableDataProvider;
import org.apache.wicket.markup.repeater.data.IDataProvider;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;

public class PrincipalDataProvider
extends SortableDataProvider<JetspeedPrincipal>
implements IDataProvider<JetspeedPrincipal> {
    private static final long serialVersionUID = -5676288154198656171L;
    private OrderBy order = OrderBy.NAME_ASC;
    private List<JetspeedPrincipal> principalList = new ArrayList();
    private boolean roleFilter = false;
    private boolean groupFilter = false;
    private String filteredRole;
    private String filteredGroup;
    private UserSubjectPrincipal currentUser;

    public PrincipalDataProvider(UserSubjectPrincipal currentUser, JetspeedPrincipalManager manager, String search) {
        this.currentUser = currentUser;
        this.refresh(manager, search);
    }

    public PrincipalDataProvider(UserSubjectPrincipal currentUser, JetspeedPrincipalManager manager, JetspeedPrincipalManager roleOrGroupManager, String search, String filteredRoleOrGroup, boolean isRoleFilter, RoleManager roleManager) {
        this.currentUser = currentUser;
        if (isRoleFilter) {
            this.filteredRole = filteredRoleOrGroup;
            this.filteredGroup = "";
            this.roleFilter = true;
            this.groupFilter = false;
        } else {
            this.filteredGroup = filteredRoleOrGroup;
            this.filteredRole = "";
            this.roleFilter = false;
            this.groupFilter = true;
        }
        this.refresh(manager, roleOrGroupManager, search, roleManager);
    }

    public Iterator<? extends JetspeedPrincipal> iterator(int first, int count) {
        int last = first + count;
        if (last > this.principalList.size()) {
            last = this.principalList.size() - 1;
        }
        if (last < 0) {
            last = 0;
        }
        return this.principalList.subList(first, last).iterator();
    }

    public IModel model(JetspeedPrincipal object) {
        return new Model((Serializable)object);
    }

    public int size() {
        return this.principalList.size();
    }

    public OrderBy getOrderBy() {
        return this.order;
    }

    public void setOrderBy(OrderBy orderBy) {
        this.order = orderBy;
    }

    public void sort() {
        Collections.sort(this.principalList, new PrincipalComparator(this, this.getOrderBy()));
    }

    public void refresh(JetspeedPrincipalManager manager, String searchString) {
        this.principalList = manager.getPrincipals(searchString);
    }

    public void refresh(JetspeedPrincipalManager manager, JetspeedPrincipalManager assocManager, String searchString, RoleManager roleManager) {
        if (this.roleFilter && !StringUtils.isEmpty((String)this.filteredRole)) {
            if (assocManager.getPrincipal(this.filteredRole) == null) {
                this.principalList = new ArrayList();
            } else {
                this.principalList = new ArrayList();
                List localList = manager.getPrincipals(searchString);
                for (JetspeedPrincipal principal : localList) {
                    try {
                        List roles = ((RoleManager)assocManager).getRolesForUser(principal.getName());
                        for (Role role : roles) {
                            if (!role.getName().equals(this.filteredRole)) continue;
                            this.principalList.add(principal);
                        }
                    }
                    catch (SecurityException e) {
                        this.principalList = new ArrayList();
                    }
                }
            }
        } else if (this.groupFilter && !StringUtils.isEmpty((String)this.filteredGroup)) {
            if (!this.filteredGroup.equals("mgr-*") && assocManager.getPrincipal(this.filteredGroup) == null) {
                this.principalList = new ArrayList();
            } else {
                this.principalList = new ArrayList();
                if (this.filteredGroup.equals("mgr-*") && roleManager != null) {
                    try {
                        List roles = roleManager.getRolesForUser(this.currentUser.getName());
                        for (Role role : roles) {
                            if (!role.getName().startsWith("mgr-")) continue;
                            String targetGroup = role.getName().substring("mgr-".length());
                            List localList = manager.getPrincipals(searchString);
                            block9: for (JetspeedPrincipal principal : localList) {
                                List groups = ((GroupManager)assocManager).getGroupsForUser(principal.getName());
                                for (Group group : groups) {
                                    if (!group.getName().equals(targetGroup)) continue;
                                    this.principalList.add(principal);
                                    continue block9;
                                }
                            }
                        }
                    }
                    catch (SecurityException e) {
                        this.principalList = new ArrayList();
                    }
                } else {
                    List localList = manager.getPrincipals(searchString);
                    for (JetspeedPrincipal principal : localList) {
                        try {
                            List groups = ((GroupManager)assocManager).getGroupsForUser(principal.getName());
                            for (Group group : groups) {
                                if (!group.getName().equals(this.filteredGroup)) continue;
                                this.principalList.add(principal);
                            }
                        }
                        catch (SecurityException e) {
                            this.principalList = new ArrayList();
                        }
                    }
                }
            }
        } else {
            this.principalList = manager.getPrincipals(searchString);
        }
    }
}

