/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.portlets.security.constraints;

import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import org.apache.commons.beanutils.DynaBean;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.validator.Arg;
import org.apache.commons.validator.Field;
import org.apache.commons.validator.Form;
import org.apache.commons.validator.GenericTypeValidator;
import org.apache.commons.validator.GenericValidator;
import org.apache.commons.validator.ValidatorAction;
import org.apache.commons.validator.ValidatorResources;
import org.apache.commons.validator.ValidatorResult;
import org.apache.commons.validator.ValidatorResults;

/*
 * Exception performing whole class analysis ignored.
 */
public class ValidationSupport {
    public static String getValueAsString(Object bean, String property) {
        Object value = null;
        if (bean instanceof Map) {
            value = ((Map)bean).get(property);
        } else if (bean instanceof DynaBean) {
            value = ((DynaBean)bean).get(property);
        } else {
            try {
                value = PropertyUtils.getProperty((Object)bean, (String)property);
            }
            catch (IllegalAccessException e) {
            }
            catch (InvocationTargetException e) {
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
        if (value == null) {
            return null;
        }
        if (value instanceof String[]) {
            return ((String[])value).length > 0 ? value.toString() : "";
        }
        if (value instanceof Collection) {
            return ((Collection)value).isEmpty() ? "" : value.toString();
        }
        return value.toString();
    }

    public static boolean validateRequired(Object bean, ValidatorAction va, Field field, Map errors, ResourceBundle bundle) {
        boolean valid;
        String value = ValidationSupport.getValueAsString((Object)bean, (String)field.getProperty());
        boolean bl = valid = !GenericValidator.isBlankOrNull((String)value);
        if (!valid) {
            if (bundle == null) {
                errors.put(field.getKey(), "Field " + field.getKey() + " is a required field.");
            } else {
                String displayName = bundle.getString(field.getArg(0).getKey());
                if (displayName == null) {
                    displayName = field.getKey();
                }
                Object[] args = new Object[]{displayName};
                String message = bundle.getString(va.getMsg());
                if (message == null) {
                    message = "Field {0} is a required field.";
                }
                errors.put(field.getKey(), MessageFormat.format(message, args));
            }
        }
        return valid;
    }

    public static boolean validateRange(Object bean, ValidatorAction va, Field field, Map errors, ResourceBundle bundle) {
        int max;
        int min;
        boolean valid;
        String maxResult;
        String minResult;
        Integer intValue;
        int value = 0;
        String result = ValidationSupport.getValueAsString((Object)bean, (String)field.getProperty());
        if (result != null && (intValue = GenericTypeValidator.formatInt((String)result)) != null) {
            value = intValue;
        }
        if ((minResult = field.getVarValue("min")) == null) {
            minResult = "0";
        }
        if ((maxResult = field.getVarValue("max")) == null) {
            maxResult = "0";
        }
        if (!(valid = GenericValidator.isInRange((int)value, (int)(min = GenericTypeValidator.formatInt((String)minResult).intValue()), (int)(max = GenericTypeValidator.formatInt((String)maxResult).intValue())))) {
            if (bundle == null) {
                errors.put(field.getKey(), "Field " + field.getKey() + " is out of range: [" + min + "- " + max + "]");
            } else {
                String displayName = bundle.getString(field.getArg(0).getKey());
                if (displayName == null) {
                    displayName = field.getKey();
                }
                Object[] args = new Object[]{displayName, minResult, maxResult};
                String message = bundle.getString(va.getMsg());
                if (message == null) {
                    message = "Field {0} is out of range: [{1} - {2}]";
                }
                errors.put(field.getKey(), MessageFormat.format(message, args));
            }
        }
        return valid;
    }

    public static boolean validateDoubleRange(Object bean, ValidatorAction va, Field field, Map errors, ResourceBundle bundle) {
        double max;
        double min;
        boolean valid;
        String maxResult;
        String minResult;
        Double doubleValue;
        double value = 0.0;
        String result = ValidationSupport.getValueAsString((Object)bean, (String)field.getProperty());
        if (result != null && (doubleValue = GenericTypeValidator.formatDouble((String)result)) != null) {
            value = doubleValue;
        }
        if ((minResult = field.getVarValue("min")) == null) {
            minResult = "0";
        }
        if ((maxResult = field.getVarValue("max")) == null) {
            maxResult = "0";
        }
        if (!(valid = GenericValidator.isInRange((double)value, (double)(min = GenericTypeValidator.formatDouble((String)minResult).doubleValue()), (double)(max = GenericTypeValidator.formatDouble((String)maxResult).doubleValue())))) {
            if (bundle == null) {
                errors.put(field.getKey(), "Field " + field.getKey() + " is out of range: [" + min + "- " + max + "]");
            } else {
                String displayName = bundle.getString(field.getArg(0).getKey());
                if (displayName == null) {
                    displayName = field.getKey();
                }
                Object[] args = new Object[]{displayName, minResult, maxResult};
                String message = bundle.getString(va.getMsg());
                if (message == null) {
                    message = "Field {0} is out of range: [{1} - {2}]";
                }
                errors.put(field.getKey(), MessageFormat.format(message, args));
            }
        }
        return valid;
    }

    public static boolean validateMask(Object bean, ValidatorAction va, Field field, Map errors, ResourceBundle bundle) {
        String value = ValidationSupport.getValueAsString((Object)bean, (String)field.getProperty());
        String mask = field.getVarValue("mask");
        if (mask == null) {
            return true;
        }
        if (GenericValidator.isBlankOrNull((String)value)) {
            return true;
        }
        boolean valid = GenericValidator.matchRegexp((String)value, (String)mask);
        if (!valid) {
            if (bundle == null) {
                errors.put(field.getKey(), "Field " + field.getKey() + " failed to match validation pattern: " + mask);
            } else {
                String displayName = bundle.getString(field.getArg(0).getKey());
                if (displayName == null) {
                    displayName = field.getKey();
                }
                Object[] args = new Object[]{displayName, mask};
                String message = bundle.getString(va.getMsg());
                if (message == null) {
                    message = "Field {0} failed to match validation pattern: {2}";
                }
                errors.put(field.getKey(), MessageFormat.format(message, args));
            }
        }
        return valid;
    }

    public static boolean validateMaxLength(Object bean, ValidatorAction va, Field field, Map errors, ResourceBundle bundle) {
        String value = ValidationSupport.getValueAsString((Object)bean, (String)field.getProperty());
        int max = Integer.parseInt(field.getVarValue("maxlength"));
        if (GenericValidator.isBlankOrNull((String)value)) {
            return true;
        }
        boolean valid = GenericValidator.maxLength((String)value, (int)max);
        if (!valid) {
            if (bundle == null) {
                errors.put(field.getKey(), "Field " + field.getKey() + " surpasses maximum length: " + max);
            } else {
                String displayName = bundle.getString(field.getArg(0).getKey());
                if (displayName == null) {
                    displayName = field.getKey();
                }
                Object[] args = new Object[]{displayName, new Integer(max)};
                String message = bundle.getString(va.getMsg());
                if (message == null) {
                    message = "Field {0} surpasses maximum length {1}";
                }
                errors.put(field.getKey(), MessageFormat.format(message, args));
            }
        }
        return valid;
    }

    public static void printResults(Object bean, ValidatorResults results, ValidatorResources resources, String formName) {
        boolean success = true;
        Form form = resources.getForm(Locale.getDefault(), formName);
        System.out.println("\n\nValidating:");
        System.out.println(bean);
        for (String propertyName : results.getPropertyNames()) {
            Field field = form.getField(propertyName);
            String prettyFieldName = propertyName;
            ValidatorResult result = results.getValidatorResult(propertyName);
            Map actionMap = result.getActionMap();
            for (String actName : actionMap.keySet()) {
                ValidatorAction action = resources.getValidatorAction(actName);
                System.out.println(propertyName + "[" + actName + "] (" + (result.isValid(actName) ? "PASSED" : "FAILED") + ")");
                if (result.isValid(actName)) continue;
                success = false;
                String message = "invalid field";
                if (actName.equals("doubleRange")) {
                    Arg f1 = field.getArg(1);
                    Arg f2 = field.getArg(2);
                    Arg f0 = field.getArg(0);
                    Object[] args = new Object[]{prettyFieldName, field.getVar("min").getValue(), field.getVar("max").getValue()};
                    System.out.println("     Error message will be: " + MessageFormat.format(message, args));
                    continue;
                }
                Object[] args = new Object[]{prettyFieldName};
                System.out.println("     Error message will be: " + MessageFormat.format(message, args));
            }
        }
        if (success) {
            System.out.println("FORM VALIDATION PASSED");
        } else {
            System.out.println("FORM VALIDATION FAILED");
        }
    }
}

