/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.portlets.security.sso;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletException;
import javax.portlet.PortletMode;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.jetspeed.sso.SSOException;
import org.apache.jetspeed.sso.SSOManager;
import org.apache.jetspeed.sso.SSOSite;
import org.apache.portals.applications.gems.browser.BrowserIterator;
import org.apache.portals.applications.gems.browser.BrowserPortlet;
import org.apache.portals.applications.gems.browser.DatabaseBrowserIterator;
import org.apache.portals.applications.gems.browser.StatusMessage;
import org.apache.portals.messaging.PortletMessaging;
import org.apache.velocity.context.Context;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SSOBrowser
extends BrowserPortlet {
    static final Logger logger = LoggerFactory.getLogger(SSOBrowser.class);
    private SSOManager sso;

    public void init(PortletConfig config) throws PortletException {
        super.init(config);
        this.sso = (SSOManager)this.getPortletContext().getAttribute("cps:SSO");
        if (null == this.sso) {
            throw new PortletException("Failed to find the SSO Provider on portlet initialization");
        }
    }

    public void getRows(RenderRequest request, String sql, int windowSize) throws Exception {
        ArrayList<String> resultSetTitleList = new ArrayList<String>();
        ArrayList<String> resultSetTypeList = new ArrayList<String>();
        try {
            Collection sites = this.sso.getSites("");
            resultSetTypeList.add(String.valueOf(12));
            resultSetTypeList.add(String.valueOf(12));
            resultSetTitleList.add(0, "Url");
            resultSetTitleList.add(1, "Site");
            ArrayList list = new ArrayList();
            if (sites != null) {
                for (SSOSite site : sites) {
                    ArrayList<String> row = new ArrayList<String>(2);
                    row.add(0, site.getURL());
                    row.add(1, site.getName());
                    list.add(row);
                }
            }
            DatabaseBrowserIterator iterator = new DatabaseBrowserIterator(list, resultSetTitleList, resultSetTypeList, windowSize);
            this.setBrowserIterator(request, (BrowserIterator)iterator);
            iterator.sort("Site");
        }
        catch (Exception e) {
            logger.error("Exception in getRows: ", (Throwable)e);
            throw e;
        }
    }

    public void doView(RenderRequest request, RenderResponse response) throws PortletException, IOException {
        StatusMessage msg;
        String selectedSiteName = (String)PortletMessaging.receive((PortletRequest)request, (String)"site", (String)"selectedName");
        if (selectedSiteName != null) {
            Context context = this.getContext(request);
            context.put("currentName", (Object)selectedSiteName);
            context.put("currentUrl", (Object)((String)PortletMessaging.receive((PortletRequest)request, (String)"site", (String)"selectedUrl")));
            String realm = (String)PortletMessaging.receive((PortletRequest)request, (String)"site", (String)"realm");
            context.put("currentRealm", (Object)realm);
            String userField = (String)PortletMessaging.receive((PortletRequest)request, (String)"site", (String)"idField");
            context.put("currentFFID", (Object)userField);
            String pwdFiled = (String)PortletMessaging.receive((PortletRequest)request, (String)"site", (String)"pwdField");
            context.put("currentFFPWD", (Object)pwdFiled);
        }
        if ((msg = (StatusMessage)PortletMessaging.consume((PortletRequest)request, (String)"SSOBrowser", (String)"status")) != null) {
            this.getContext(request).put("statusMsg", (Object)msg);
        }
        super.doView(request, response);
    }

    protected void clearPortletMessages(PortletRequest request, PortletResponse response) {
        PortletMessaging.cancel((PortletRequest)request, (String)"site", (String)"selectedName");
        PortletMessaging.cancel((PortletRequest)request, (String)"site", (String)"selectedUrl");
        PortletMessaging.cancel((PortletRequest)request, (String)"site", (String)"realm");
        PortletMessaging.cancel((PortletRequest)request, (String)"site", (String)"idField");
        PortletMessaging.cancel((PortletRequest)request, (String)"site", (String)"pwdField");
    }

    protected void setPortletMessage(PortletRequest request, String key, String msg) throws IOException {
        if (StringUtils.isNotEmpty((String)msg)) {
            PortletMessaging.publish((PortletRequest)request, (String)"site", (String)key, (Object)msg);
        } else {
            PortletMessaging.cancel((PortletRequest)request, (String)"site", (String)key);
        }
    }

    public void processAction(ActionRequest request, ActionResponse response) throws PortletException, IOException {
        if (request.getPortletMode() == PortletMode.VIEW) {
            SSOSite site;
            String selectedSite = request.getParameter("ssoSite");
            if (selectedSite != null && (site = this.sso.getSiteByName(selectedSite)) != null) {
                this.setPortletMessage((PortletRequest)request, "selectedUrl", site.getURL());
                this.setPortletMessage((PortletRequest)request, "selectedName", site.getName());
                this.setPortletMessage((PortletRequest)request, "change", selectedSite);
                this.setPortletMessage((PortletRequest)request, "realm", site.getRealm());
                this.setPortletMessage((PortletRequest)request, "idField", site.getFormUserField());
                this.setPortletMessage((PortletRequest)request, "pwdField", site.getFormPwdField());
            }
            String refresh = request.getParameter("sso.refresh");
            String save = request.getParameter("sso.save");
            String neue = request.getParameter("sso.new");
            String delete = request.getParameter("ssoDelete");
            if (refresh != null) {
                this.clearBrowserIterator((PortletRequest)request);
            } else if (neue != null) {
                this.clearPortletMessages((PortletRequest)request, (PortletResponse)response);
            } else if (delete != null && !this.isEmpty(delete)) {
                try {
                    SSOSite site2 = null;
                    site2 = this.sso.getSiteByName(delete);
                    if (site2 != null) {
                        this.sso.removeSite(site2);
                        this.clearBrowserIterator((PortletRequest)request);
                        this.clearPortletMessages((PortletRequest)request, (PortletResponse)response);
                    }
                }
                catch (SSOException e) {
                    this.publishStatusMessage((PortletRequest)request, "SSOBrowser", "status", (Throwable)e, "Could not remove site");
                }
            } else if (save != null) {
                String siteName = request.getParameter("site.name");
                String siteUrl = request.getParameter("site.url");
                String siteRealm = request.getParameter("site.realm");
                String siteFormID = request.getParameter("site.form_field_ID");
                String siteFormPWD = request.getParameter("site.form_field_PWD");
                if (!this.isEmpty(siteName) && !this.isEmpty(siteUrl)) {
                    try {
                        SSOSite site3 = null;
                        String old = (String)PortletMessaging.receive((PortletRequest)request, (String)"site", (String)"selectedName");
                        site3 = old != null ? this.sso.getSiteByName(old) : this.sso.getSiteByName(siteName);
                        boolean isNewSite = false;
                        if (site3 == null) {
                            isNewSite = true;
                            site3 = this.sso.newSite(siteName, siteUrl);
                        }
                        site3.setName(siteName);
                        site3.setURL(siteUrl);
                        site3.setRealm(siteRealm);
                        site3.setFormUserField(siteFormID);
                        site3.setFormPwdField(siteFormPWD);
                        site3.setFormAuthentication(StringUtils.isNotEmpty((String)siteFormID) && StringUtils.isNotEmpty((String)siteFormPWD));
                        site3.setChallengeResponseAuthentication(!site3.isFormAuthentication());
                        if (isNewSite) {
                            this.sso.addSite(site3);
                        } else {
                            this.sso.updateSite(site3);
                        }
                        this.clearBrowserIterator((PortletRequest)request);
                        PortletMessaging.publish((PortletRequest)request, (String)"site", (String)"selectedName", (Object)siteName);
                        PortletMessaging.publish((PortletRequest)request, (String)"site", (String)"selectedUrl", (Object)siteUrl);
                        PortletMessaging.publish((PortletRequest)request, (String)"site", (String)"realm", (Object)siteRealm);
                        PortletMessaging.publish((PortletRequest)request, (String)"site", (String)"idField", (Object)siteFormID);
                        PortletMessaging.publish((PortletRequest)request, (String)"site", (String)"pwdField", (Object)siteFormPWD);
                    }
                    catch (SSOException e) {
                        this.publishStatusMessage((PortletRequest)request, "SSOBrowser", "status", (Throwable)e, "Could not store site");
                    }
                }
            }
        }
        super.processAction(request, response);
    }

    private boolean isEmpty(String s) {
        if (s == null) {
            return true;
        }
        return s.trim().equals("");
    }
}

