/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.portlets.site;

import java.io.Serializable;
import java.util.List;
import org.apache.jetspeed.om.folder.FolderNotFoundException;
import org.apache.jetspeed.om.folder.InvalidFolderException;
import org.apache.jetspeed.om.folder.MenuDefinition;
import org.apache.jetspeed.page.PageNotFoundException;
import org.apache.jetspeed.page.document.NodeException;
import org.apache.jetspeed.portlets.JetspeedServiceLocator;

public class MenuTreeNode
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String path;
    private String name;
    private String type;
    private JetspeedServiceLocator locator;

    public MenuTreeNode(String name, JetspeedServiceLocator locator) {
        this.name = name;
        this.locator = locator;
    }

    public MenuTreeNode(String name, String path, String type, JetspeedServiceLocator locator) {
        this.name = name;
        this.locator = locator;
        this.type = type;
        this.path = path;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.name != null ? this.name : super.toString();
    }

    public MenuDefinition getDefinition() {
        if (this.type.equals("folder")) {
            this.getFolderMenuDefinition();
        } else if (this.type.equals("page")) {
            this.getPageMenuDefinition();
        }
        return null;
    }

    private MenuDefinition getPageMenuDefinition() {
        boolean definitionFound;
        MenuDefinition definition = null;
        try {
            return this.getMenu(this.locator.getPageManager().getPage(this.path).getMenuDefinitions());
        }
        catch (PageNotFoundException e) {
            definitionFound = false;
        }
        catch (InvalidFolderException e) {
            definitionFound = false;
        }
        catch (NodeException e) {
            definitionFound = false;
        }
        if (!definitionFound) {
            definition = this.locator.getPageManager().newPageMenuDefinition();
        }
        return definition;
    }

    private MenuDefinition getFolderMenuDefinition() {
        boolean definitionFound;
        MenuDefinition definition = null;
        try {
            return this.getMenu(this.locator.getPageManager().getFolder(this.path).getMenuDefinitions());
        }
        catch (FolderNotFoundException e) {
            definitionFound = false;
        }
        catch (InvalidFolderException e) {
            definitionFound = false;
        }
        catch (NodeException e) {
            definitionFound = false;
        }
        if (!definitionFound) {
            definition = this.locator.getPageManager().newFolderMenuDefinition();
        }
        return definition;
    }

    private MenuDefinition getMenu(List menuDefinitions) {
        for (Object menuDefinition : menuDefinitions) {
            MenuDefinition definition = (MenuDefinition)menuDefinition;
            if (!definition.getName().equals(this.name)) continue;
            return definition;
        }
        if (this.type.equals("page")) {
            return this.locator.getPageManager().newPageMenuDefinition();
        }
        return this.locator.getPageManager().newFolderMenuDefinition();
    }
}

