/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.portlets.spaces;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletContext;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.apache.jetspeed.Jetspeed;
import org.apache.jetspeed.administration.PortalAdministration;
import org.apache.jetspeed.container.url.BasePortalURL;
import org.apache.jetspeed.om.folder.Folder;
import org.apache.jetspeed.om.page.ContentPage;
import org.apache.jetspeed.om.page.Link;
import org.apache.jetspeed.om.page.Page;
import org.apache.jetspeed.page.PageManager;
import org.apache.jetspeed.page.document.Node;
import org.apache.jetspeed.portalsite.Menu;
import org.apache.jetspeed.portalsite.MenuElement;
import org.apache.jetspeed.portalsite.PortalSiteRequestContext;
import org.apache.jetspeed.portlets.spaces.NodeBean;
import org.apache.jetspeed.portlets.spaces.SpaceAdminUtils;
import org.apache.jetspeed.portlets.spaces.SpaceBean;
import org.apache.jetspeed.portlets.spaces.SpaceChangeContext;
import org.apache.jetspeed.portlets.spaces.SpaceNavigator;
import org.apache.jetspeed.request.RequestContext;
import org.apache.jetspeed.spaces.Spaces;
import org.apache.portals.bridges.common.GenericServletPortlet;
import org.apache.portals.messaging.PortletMessaging;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;

public class PageNavigator
extends GenericServletPortlet {
    private static String PORTAL_SITE_SESSION_CONTEXT_ATTR_KEY = "org.apache.jetspeed.portalsite.PortalSiteSessionContext";
    private static String PORTAL_SITE_REQUEST_CONTEXT_ATTR_KEY = "org.apache.jetspeed.portalsite.PortalSiteRequestContext";
    public static final String DEFAULT_PAGES_MENU = "pages";
    public static final String DEFAULT_LINKS_MENU = "links";
    public static final String DEFAULT_SPACE_NAVS_MENU = "space-navigations";
    public static final String DEFAULT_SPACE_LINKS_MENU = "space-links";
    public static final String DEFAULT_TEMPLATE_PAGE = "/_template/new-user/min.psml";
    public static final String[] DEFAULT_MANAGEABLE_NODE_TYPES = new String[]{".psml", "folder", ".link"};
    public static final String FOLDER_SPACE_FLAGS = "folderSpaceFlags";
    public static final String TEMPLATE_PAGE_NODES = "templatePageNodes";
    private static Logger log = LoggerFactory.getLogger(PageNavigator.class);
    private Spaces spacesService;
    private PortalAdministration admin;
    protected PageManager pageManager;
    private BasePortalURL baseUrlAccess = null;
    private String defaultMenu = "space-navigations";
    private String defaultLinksMenu = "space-links";
    protected String yuiScriptPath = "/javascript/yui/build/yui/yui-min.js";

    public void init(PortletConfig config) throws PortletException {
        super.init(config);
        PortletContext context = this.getPortletContext();
        this.spacesService = (Spaces)context.getAttribute("cps:SpacesService");
        if (this.spacesService == null) {
            throw new PortletException("Could not get instance of portal spaces service component");
        }
        this.admin = (PortalAdministration)this.getPortletContext().getAttribute("cps:PortalAdministration");
        if (null == this.admin) {
            throw new PortletException("Failed to find the Portal Administration on portlet initialization");
        }
        this.pageManager = (PageManager)context.getAttribute("cps:PageManager");
        if (null == this.pageManager) {
            throw new PortletException("Failed to find the Page Manager on portlet initialization");
        }
        try {
            this.baseUrlAccess = (BasePortalURL)Jetspeed.getComponentManager().lookupComponent("BasePortalURL");
        }
        catch (Exception e) {
            this.baseUrlAccess = null;
        }
        String param = config.getInitParameter("yuiScriptPath");
        if (param != null) {
            this.yuiScriptPath = param;
        }
    }

    protected void doHeaders(RenderRequest request, RenderResponse response) {
        super.doHeaders(request, response);
        RequestContext rc = (RequestContext)request.getAttribute("org.apache.jetspeed.request.RequestContext");
        Element headElem = response.createElement("script");
        headElem.setAttribute("language", "javascript");
        String scriptPath = rc.getRequest().getContextPath() + this.yuiScriptPath;
        headElem.setAttribute("id", "header.yui.library.include");
        headElem.setAttribute("src", scriptPath);
        headElem.setAttribute("type", "text/javascript");
        response.addProperty("javax.portlet.markup.head.element", headElem);
    }

    public void doView(RenderRequest request, RenderResponse response) throws PortletException, IOException {
        String newSpace = (String)PortletMessaging.consume((PortletRequest)request, (String)"PageNavigator", (String)"spaceChange");
        if (newSpace != null) {
            request.getPortletSession().removeAttribute("spaces", 1);
            request.getPortletSession().removeAttribute("space", 1);
        }
        SpaceChangeContext scc = SpaceNavigator.changeSpace((RenderRequest)request, (Spaces)this.spacesService, (String)newSpace);
        SpaceBean spaceBean = scc.getSpace();
        List spaceBeans = scc.getSpaces();
        request.setAttribute("space", (Object)spaceBean);
        request.setAttribute("spaces", (Object)spaceBeans);
        request.setAttribute("PageNavigator", (Object)this);
        request.setAttribute("spaceMenuElements", (Object)this.getSpaceMenuElements(spaceBean, (PortletRequest)request));
        request.setAttribute("spaceLinkElements", (Object)this.getSpaceLinkMenuElements(spaceBean, (PortletRequest)request));
        request.setAttribute("templatePages", (Object)this.getTemplatePageNodes((PortletRequest)request));
        String[] manageableNodeTypes = DEFAULT_MANAGEABLE_NODE_TYPES;
        String manageableNodeTypesPref = request.getPreferences().getValue("manageableNodeTypes", null);
        if (!StringUtils.isBlank((String)manageableNodeTypesPref)) {
            manageableNodeTypes = StringUtils.split((String)manageableNodeTypesPref, (String)", \t\r\n");
        }
        request.setAttribute("manageableNodeTypes", (Object)manageableNodeTypes);
        if (SpaceAdminUtils.isUserSpaceOwner((SpaceBean)spaceBean, (PortletRequest)request) || SpaceAdminUtils.isUserSpaceAdmin((SpaceBean)spaceBean, (PortalAdministration)this.admin, (PortletRequest)request)) {
            request.setAttribute("pageEditable", (Object)Boolean.TRUE);
        }
        super.doView(request, response);
    }

    public void processAction(ActionRequest actionRequest, ActionResponse actionResponse) throws PortletException, IOException {
        String name = actionRequest.getParameter("name");
        String type = actionRequest.getParameter("type");
        String templatePage = StringUtils.defaultString((String)actionRequest.getParameter("templatePage"), null);
        SpaceBean space = (SpaceBean)actionRequest.getPortletSession().getAttribute("space", 1);
        if (space == null) {
            log.warn("Space not found in session.");
            return;
        }
        if (StringUtils.isBlank((String)name)) {
            log.warn("Blank name to create a node of type " + type);
            return;
        }
        if (StringUtils.isBlank((String)type)) {
            throw new PortletException("Blank node type: " + type);
        }
        if ((".psml".equals(type) || "folder".equals(type)) && StringUtils.isBlank((String)templatePage) && StringUtils.isBlank((String)(templatePage = actionRequest.getPreferences().getValue("defaultTemplatePage", null)))) {
            throw new PortletException("Invalid template page: " + templatePage);
        }
        try {
            RequestContext requestContext = (RequestContext)actionRequest.getAttribute("org.apache.jetspeed.request.RequestContext");
            ContentPage contentPage = requestContext.getPage();
            String spacePath = space.getPath();
            String contentPagePath = contentPage.getPath();
            String contentFolderPath = StringUtils.defaultIfEmpty((String)StringUtils.substringBeforeLast((String)contentPagePath, (String)"/"), (String)"/");
            String nodeName = name.replace(' ', '_');
            String nodePath = null;
            nodePath = contentFolderPath.startsWith(spacePath) ? StringUtils.removeEnd((String)contentFolderPath, (String)"/") + "/" + StringUtils.removeStart((String)nodeName, (String)"/") : StringUtils.removeEnd((String)spacePath, (String)"/") + "/" + StringUtils.removeStart((String)nodeName, (String)"/");
            if (".psml".equals(type)) {
                String path = nodePath + ".psml";
                Page source = this.pageManager.getPage(templatePage);
                Page newPage = this.pageManager.copyPage(source, path, false);
                newPage.setTitle(name);
                this.pageManager.updatePage(newPage);
                requestContext.setSessionAttribute(PORTAL_SITE_SESSION_CONTEXT_ATTR_KEY, null);
                String redirect = this.admin.getPortalURL((PortletRequest)actionRequest, (PortletResponse)actionResponse, path);
                actionResponse.sendRedirect(redirect);
            } else if ("folder".equals(type)) {
                String path = nodePath;
                Folder folder = this.pageManager.newFolder(path);
                folder.setTitle(name);
                this.pageManager.updateFolder(folder);
                String defaultPagePath = folder.getPath() + "/" + "default-page.psml";
                Page source = this.pageManager.getPage(templatePage);
                Page newPage = this.pageManager.copyPage(source, defaultPagePath, false);
                this.pageManager.updatePage(newPage);
                requestContext.setSessionAttribute(PORTAL_SITE_SESSION_CONTEXT_ATTR_KEY, null);
            } else if (".link".equals(type)) {
                String path = nodePath + ".link";
                Link link = this.pageManager.newLink(path);
                link.setTitle(name);
                this.pageManager.updateLink(link);
                requestContext.setSessionAttribute(PORTAL_SITE_SESSION_CONTEXT_ATTR_KEY, null);
            }
        }
        catch (Exception e) {
            log.error("Failed to update page.", (Throwable)e);
        }
    }

    public String getAbsoluteUrl(String relativePath, RenderResponse renderResponse, RequestContext rc) {
        if (relativePath != null && relativePath.indexOf("://") == -1 && relativePath.indexOf("mailto:") == -1) {
            HttpServletRequest request = rc.getRequest();
            StringBuffer path = new StringBuffer();
            if (!rc.getPortalURL().isRelativeOnly()) {
                if (this.baseUrlAccess == null) {
                    path.append(request.getScheme()).append("://").append(request.getServerName()).append(":").append(request.getServerPort());
                } else {
                    path.append(this.baseUrlAccess.getServerScheme()).append("://").append(this.baseUrlAccess.getServerName()).append(":").append(this.baseUrlAccess.getServerPort());
                }
            }
            return renderResponse.encodeURL(path.append(request.getContextPath()).append(request.getServletPath()).append(relativePath).toString());
        }
        return relativePath;
    }

    private List<MenuElement> getSpaceMenuElements(SpaceBean space, PortletRequest request) {
        List spaceMenuElements = null;
        try {
            RequestContext rc = (RequestContext)request.getAttribute("org.apache.jetspeed.request.RequestContext");
            PortalSiteRequestContext psrc = (PortalSiteRequestContext)rc.getAttribute(PORTAL_SITE_REQUEST_CONTEXT_ATTR_KEY);
            Menu spaceMenu = null;
            String menuName = request.getPreferences().getValue("Menu", this.defaultMenu);
            try {
                spaceMenu = psrc.getMenu(menuName);
            }
            catch (Exception e) {
                log.error("Failed to retrieve menu.", (Throwable)e);
            }
            if (spaceMenu == null && !DEFAULT_PAGES_MENU.equals(menuName) && (spaceMenu = psrc.getMenu(DEFAULT_PAGES_MENU)) != null) {
                this.defaultMenu = DEFAULT_PAGES_MENU;
            }
            if (spaceMenu != null) {
                spaceMenuElements = spaceMenu.getElements();
            }
        }
        catch (Exception e) {
            log.error("Failed to retrieve space menu elements.", (Throwable)e);
        }
        if (spaceMenuElements == null) {
            spaceMenuElements = Collections.emptyList();
        }
        return spaceMenuElements;
    }

    private List<MenuElement> getSpaceLinkMenuElements(SpaceBean space, PortletRequest request) {
        List spaceLinkMenuElements = null;
        try {
            RequestContext rc = (RequestContext)request.getAttribute("org.apache.jetspeed.request.RequestContext");
            PortalSiteRequestContext psrc = (PortalSiteRequestContext)rc.getAttribute(PORTAL_SITE_REQUEST_CONTEXT_ATTR_KEY);
            Menu spaceLinksMenu = null;
            String linksMenuName = request.getPreferences().getValue("LinkMenu", this.defaultLinksMenu);
            try {
                spaceLinksMenu = psrc.getMenu(linksMenuName);
            }
            catch (Exception e) {
                log.error("Failed to retrieve menu.", (Throwable)e);
            }
            if (spaceLinksMenu == null && !DEFAULT_LINKS_MENU.equals(linksMenuName) && (spaceLinksMenu = psrc.getMenu(DEFAULT_LINKS_MENU)) != null) {
                this.defaultLinksMenu = DEFAULT_LINKS_MENU;
            }
            if (spaceLinksMenu != null) {
                spaceLinkMenuElements = spaceLinksMenu.getElements();
            }
        }
        catch (Exception e) {
            log.error("Failed to retrieve space menu elements.", (Throwable)e);
        }
        if (spaceLinkMenuElements == null) {
            spaceLinkMenuElements = Collections.emptyList();
        }
        return spaceLinkMenuElements;
    }

    private List<NodeBean> getTemplatePageNodes(PortletRequest request) {
        ArrayList<NodeBean> templatePageNodes = (ArrayList<NodeBean>)request.getPortletSession(true).getAttribute(TEMPLATE_PAGE_NODES);
        if (templatePageNodes == null) {
            templatePageNodes = new ArrayList<NodeBean>();
            String templatePages = request.getPreferences().getValue("templatePages", null);
            if (!StringUtils.isBlank((String)templatePages)) {
                String[] templatePagePaths;
                for (String templatePagePath : templatePagePaths = StringUtils.split((String)templatePages, (String)", \t\r\n")) {
                    try {
                        Page templatePage = this.pageManager.getPage(templatePagePath);
                        templatePageNodes.add(new NodeBean((Node)templatePage));
                    }
                    catch (SecurityException e) {
                    }
                    catch (Exception e) {
                        log.warn("Invalid template page path: " + templatePagePath + ". {}", (Object)e.toString());
                    }
                }
            }
            request.getPortletSession().setAttribute(TEMPLATE_PAGE_NODES, templatePageNodes);
        }
        return templatePageNodes;
    }
}

