/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.portlets.sso;

import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.servlet.http.HttpSession;
import org.apache.http.HttpEntity;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.message.BasicNameValuePair;
import org.apache.jetspeed.portlets.sso.JetspeedSSOSiteCredentials;
import org.apache.jetspeed.portlets.sso.JetspeedSSOUtils;
import org.apache.portals.applications.webcontent2.proxy.ProxyContext;
import org.apache.portals.applications.webcontent2.proxy.ReverseProxyException;
import org.apache.portals.applications.webcontent2.proxy.command.InitHttpRequestCommand;
import org.apache.portals.applications.webcontent2.proxy.impl.ServletRequestContext;

public class SSOInitHttpRequestCommand
extends InitHttpRequestCommand {
    protected HttpRequestBase createHttpRequest(ProxyContext context) throws ReverseProxyException, IOException {
        URI remoteURI;
        List ssoCredsList = this.getJetspeedFormSSOSiteCredentials(context);
        JetspeedSSOSiteCredentials ssoSiteCreds = JetspeedSSOUtils.getBestMatchedSSOSiteCrendentials((Collection)ssoCredsList, (URI)(remoteURI = context.getRemoteURI()));
        if (ssoSiteCreds != null) {
            HttpPost httpRequest = new HttpPost(remoteURI);
            ArrayList<BasicNameValuePair> formParams = new ArrayList<BasicNameValuePair>();
            formParams.add(new BasicNameValuePair(ssoSiteCreds.getFormUserField(), ssoSiteCreds.getUsername()));
            formParams.add(new BasicNameValuePair(ssoSiteCreds.getFormPwdField(), ssoSiteCreds.getPassword()));
            httpRequest.setEntity((HttpEntity)new UrlEncodedFormEntity(formParams));
            return httpRequest;
        }
        return super.createHttpRequest(context);
    }

    private List<JetspeedSSOSiteCredentials> getJetspeedFormSSOSiteCredentials(ProxyContext context) {
        List ssoCredsList = null;
        HttpSession session = ((ServletRequestContext)context.getRequestContext()).getServletRequest().getSession(false);
        if (session != null) {
            ssoCredsList = (List)session.getAttribute("org.apache.jetspeed.portlets.sso.ssoSiteCredsOfSubject");
        }
        if (ssoCredsList == null) {
            return null;
        }
        ArrayList<JetspeedSSOSiteCredentials> formCredsList = new ArrayList<JetspeedSSOSiteCredentials>();
        for (JetspeedSSOSiteCredentials ssoCreds : ssoCredsList) {
            if (!ssoCreds.isFormAuthentication()) continue;
            formCredsList.add(ssoCreds);
        }
        return formCredsList;
    }
}

