/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.portlets.sso;

import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.Principal;
import java.util.Collection;
import javax.portlet.PortletRequest;
import javax.portlet.RenderRequest;
import javax.security.auth.Subject;
import org.apache.jetspeed.portlets.sso.JetspeedSSOUtils;
import org.apache.jetspeed.security.JSSubject;
import org.apache.jetspeed.security.JetspeedPrincipal;
import org.apache.jetspeed.security.PasswordCredential;
import org.apache.jetspeed.sso.SSOException;
import org.apache.jetspeed.sso.SSOManager;
import org.apache.jetspeed.sso.SSOSite;
import org.apache.jetspeed.sso.SSOUser;
import org.apache.portals.applications.gems.browser.StatusMessage;
import org.apache.portals.messaging.PortletMessaging;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public abstract class SSOPortletUtil {
    static final Logger logger = LoggerFactory.getLogger(SSOPortletUtil.class);

    public static Subject getSubject() {
        AccessControlContext context = AccessController.getContext();
        return JSSubject.getSubject((AccessControlContext)context);
    }

    public static SSOUser getRemoteUser(SSOManager sso, PortletRequest request, SSOSite site) throws SSOException {
        Collection remoteUsers;
        Subject subject = SSOPortletUtil.getSubject();
        if (subject != null && (remoteUsers = sso.getRemoteUsers(site, subject)).size() == 1) {
            return (SSOUser)remoteUsers.iterator().next();
        }
        return null;
    }

    public static void updateUser(SSOManager sso, PortletRequest request, SSOSite site, String newPrincipal, String newPassword) throws SSOException {
        SSOUser remoteUser = SSOPortletUtil.getRemoteUser((SSOManager)sso, (PortletRequest)request, (SSOSite)site);
        if (remoteUser != null) {
            if (!remoteUser.getName().equals(newPrincipal)) {
                remoteUser.setName(newPrincipal);
                sso.updateUser(remoteUser);
            }
            sso.setPassword(remoteUser, newPassword);
        } else {
            Subject subject = SSOPortletUtil.getSubject();
            Principal ownerPrincipal = null;
            for (Principal p : subject.getPrincipals()) {
                if (!(p instanceof JetspeedPrincipal)) continue;
                ownerPrincipal = p;
                break;
            }
            sso.addUser(site, (JetspeedPrincipal)ownerPrincipal, newPrincipal, newPassword);
        }
    }

    public static PasswordCredential getCredentialsForSite(SSOManager sso, String siteUrl, RenderRequest request) {
        PasswordCredential pwc = null;
        SSOSite site = JetspeedSSOUtils.getBestSubjectSSOSiteByURL((SSOManager)sso, (String)siteUrl);
        if (site != null) {
            return SSOPortletUtil.getCredentialsForSite((SSOManager)sso, (SSOSite)site, (RenderRequest)request);
        }
        return pwc;
    }

    public static PasswordCredential getCredentialsForSite(SSOManager sso, SSOSite site, RenderRequest request) {
        PasswordCredential pwc = null;
        try {
            SSOUser remoteUser = SSOPortletUtil.getRemoteUser((SSOManager)sso, (PortletRequest)request, (SSOSite)site);
            if (remoteUser != null) {
                pwc = sso.getCredentials(remoteUser);
            }
        }
        catch (SSOException sx) {
            // empty catch block
        }
        return pwc;
    }

    public static void publishStatusMessage(PortletRequest request, String portlet, String topic, Throwable e, String message) {
        String msg = message + ": " + e.toString();
        Throwable cause = e.getCause();
        if (cause != null) {
            msg = msg + ", " + cause.getMessage();
        }
        StatusMessage sm = new StatusMessage(msg, "portlet-msg-error");
        try {
            PortletMessaging.publish((PortletRequest)request, (String)portlet, (String)topic, (Object)sm);
        }
        catch (Exception ee) {
            logger.error("Failed to publish message.", e);
        }
    }
}

