/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.portlets.sso;

import java.io.IOException;
import java.io.Writer;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.Principal;
import java.util.Collection;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletContext;
import javax.portlet.PortletException;
import javax.portlet.PortletURL;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.security.auth.Subject;
import org.apache.jetspeed.portlets.sso.JetspeedSSOUtils;
import org.apache.jetspeed.security.JSSubject;
import org.apache.jetspeed.security.JetspeedPrincipal;
import org.apache.jetspeed.sso.SSOClient;
import org.apache.jetspeed.sso.SSOException;
import org.apache.jetspeed.sso.SSOManager;
import org.apache.jetspeed.sso.SSOSite;
import org.apache.jetspeed.sso.SSOUser;
import org.apache.portals.bridges.common.ScriptPostProcess;
import org.apache.portals.bridges.velocity.GenericVelocityPortlet;

public class SSOProxyPortlet
extends GenericVelocityPortlet {
    private PortletContext context;
    private SSOManager sso;
    private boolean isAuthenticated = false;
    public String defaultEncoding = "UTF-8";
    static final int BLOCK_SIZE = 4096;
    static final String ACTION_PARAMETER_SSOPROXY = "SSOProxy";
    static final String DESTINATION_URL = "DestinationURL";
    static final String SSO_SITE = "SSOSite";
    static final String FORCE_SSO_REFRESH = "ForceSSORefresh";
    static final String ENCODING = "Encoding";
    private String encoding;

    public void init(PortletConfig config) throws PortletException {
        super.init(config);
        this.context = this.getPortletContext();
        this.sso = (SSOManager)this.context.getAttribute("cps:SSO");
        if (null == this.sso) {
            throw new PortletException("Failed to find SSO Provider on portlet initialization");
        }
    }

    public void processAction(ActionRequest request, ActionResponse actionResponse) throws PortletException, IOException {
        String ssoProxyAction = request.getParameter(ACTION_PARAMETER_SSOPROXY);
        this.encoding = request.getParameter(ENCODING);
        if (this.encoding == null) {
            this.encoding = this.defaultEncoding;
        }
        super.processAction(request, actionResponse);
    }

    public void doView(RenderRequest request, RenderResponse response) throws PortletException, IOException {
        boolean forceRefresh = Boolean.parseBoolean(request.getPreferences().getValue(FORCE_SSO_REFRESH, "false"));
        String destinationURL = request.getPreferences().getValue(DESTINATION_URL, null);
        String ssoSite = request.getPreferences().getValue(SSO_SITE, null);
        if (ssoSite == null) {
            String warningMessage = this.getResourceBundle(request.getLocale()).getString("no.credentials");
            response.getWriter().print(warningMessage);
            return;
        }
        response.setContentType("text/html");
        try {
            Collection remoteUsers;
            Principal p;
            StringBuffer page = new StringBuffer();
            SSOSite site = JetspeedSSOUtils.getBestSubjectSSOSiteByURL((SSOManager)this.sso, (String)ssoSite);
            if (site == null) {
                response.getWriter().println("<P>Could not find site with name " + ssoSite + "</P>");
                return;
            }
            if (destinationURL == null) {
                destinationURL = site.getURL();
            }
            if ((p = request.getUserPrincipal()) instanceof JetspeedPrincipal && (remoteUsers = this.sso.getRemoteUsers(site, this.getSubject())).size() > 0) {
                SSOUser remoteUser = (SSOUser)remoteUsers.iterator().next();
                SSOClient client = this.sso.getClient(site, remoteUser);
                if (client == null) {
                    response.getWriter().println("<P>Could not create client for site with name " + ssoSite + " and user " + request.getUserPrincipal().getName() + "</P>");
                    return;
                }
                client.write(destinationURL, forceRefresh, (Writer)response.getWriter());
                PortletURL actionURL = response.createActionURL();
                ScriptPostProcess processor = new ScriptPostProcess();
                processor.setInitalPage(page);
                processor.postProcessPage(actionURL, ACTION_PARAMETER_SSOPROXY);
                String finalPage = processor.getFinalizedPage();
                response.getWriter().println(finalPage);
            }
        }
        catch (SSOException e) {
            response.getWriter().println("<P>Error rendering page. Error message<BR>" + e.getMessage() + "</P>");
        }
    }

    public void doEdit(RenderRequest request, RenderResponse response) throws PortletException, IOException {
        super.doEdit(request, response);
    }

    private Subject getSubject() {
        AccessControlContext context = AccessController.getContext();
        return JSSubject.getSubject((AccessControlContext)context);
    }
}

