/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.security.mfa.impl;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.ref.SoftReference;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Properties;
import java.util.Random;
import java.util.TimeZone;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriter;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.jetspeed.security.mfa.MFA;
import org.apache.jetspeed.security.mfa.MultiFacetedAuthentication;
import org.apache.jetspeed.security.mfa.impl.CaptchaConfiguration;
import org.apache.jetspeed.security.mfa.impl.CaptchaImageResource;
import org.apache.jetspeed.security.mfa.impl.DefaultJPEGImgDecoder;
import org.apache.jetspeed.security.mfa.impl.MultiFacetedAuthenticationImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public final class CaptchaImageResource {
    private static final long serialVersionUID = 1L;
    static final Logger logger = LoggerFactory.getLogger(CaptchaImageResource.class);
    private String challengeId;
    private List charAttsList;
    private int height = 0;
    private int width = 0;
    private byte[] background = null;
    private BufferedImage image = null;
    private CaptchaConfiguration config;
    private transient SoftReference imageData;

    public CaptchaImageResource(CaptchaConfiguration config) {
        this(config, null);
    }

    public CaptchaImageResource(CaptchaConfiguration config, String challengeId) {
        this.challengeId = challengeId == null ? CaptchaImageResource.randomString((int)config.getTextMinlength(), (int)config.getTextMaxlength()) : challengeId;
        this.config = config;
        this.background = null;
    }

    public void setBackgroundImage(byte[] background) {
        this.background = background;
    }

    public final String getChallengeId() {
        return this.challengeId;
    }

    public final void invalidate() {
        this.imageData = null;
    }

    public void saveTo(OutputStream target) throws IOException {
        byte[] data = this.getImageData();
        target.write(data);
    }

    public byte[] getImageBytes() {
        try {
            return this.getImageData();
        }
        catch (IOException e) {
            logger.error("Unexpected exception during getImageBytes().", (Throwable)e);
            return null;
        }
    }

    protected final byte[] getImageData() throws IOException {
        byte[] data = null;
        if (this.imageData != null) {
            data = (byte[])this.imageData.get();
        }
        if (data == null) {
            data = this.render();
            this.imageData = new SoftReference<byte[]>(data);
        }
        return data;
    }

    private Font getFont(String fontName) {
        return new Font(fontName, this.config.getFontStyle(), this.config.getFontSize());
    }

    public void init() {
        boolean emptyBackground = true;
        if (this.config.isUseImageBackground() && this.background != null) {
            ByteArrayInputStream is = new ByteArrayInputStream(this.background);
            DefaultJPEGImgDecoder decoder = new DefaultJPEGImgDecoder();
            try {
                this.image = decoder.decodeAsBufferedImage((InputStream)is);
                this.width = this.image.getWidth();
                this.height = this.image.getHeight();
                emptyBackground = false;
            }
            catch (Exception e) {
                emptyBackground = true;
            }
        }
        if (emptyBackground) {
            this.width = this.config.getTextMarginLeft() * 2;
            this.height = this.config.getTextMarginBottom() * 6;
        }
        char[] chars = this.challengeId.toCharArray();
        this.charAttsList = new ArrayList();
        TextLayout text = null;
        AffineTransform textAt = null;
        String[] fontNames = this.config.getFontNames();
        for (int i = 0; i < chars.length; ++i) {
            String fontName = fontNames.length == 1 ? fontNames[0] : fontNames[CaptchaImageResource.randomInt((int)0, (int)fontNames.length)];
            int rise = this.config.getTextRiseRange();
            if (rise > 0) {
                rise = CaptchaImageResource.randomInt((int)this.config.getTextMarginBottom(), (int)(this.config.getTextMarginBottom() + this.config.getTextRiseRange()));
            }
            if (this.config.getTextShear() > 0.0 || this.config.getTextRotation() > 0) {
                double dRotation = 0.0;
                if (this.config.getTextRotation() > 0) {
                    dRotation = Math.toRadians(CaptchaImageResource.randomInt((int)(-this.config.getTextRotation()), (int)this.config.getTextRotation()));
                }
                double shearX = 0.0;
                double shearY = 0.0;
                if (this.config.getTextShear() > 0.0) {
                    Random ran = new Random();
                    shearX = ran.nextDouble() * this.config.getTextShear();
                    shearY = ran.nextDouble() * this.config.getTextShear();
                }
                CharAttributes cf = new CharAttributes(chars[i], fontName, dRotation, rise, shearX, shearY);
                this.charAttsList.add(cf);
                text = new TextLayout(chars[i] + "", this.getFont(fontName), new FontRenderContext(null, this.config.isFontAntialiasing(), false));
                textAt = new AffineTransform();
                if (this.config.getTextRotation() > 0) {
                    textAt.rotate(dRotation);
                }
                if (this.config.getTextShear() > 0.0) {
                    textAt.shear(shearX, shearY);
                }
            } else {
                CharAttributes cf = new CharAttributes(chars[i], fontName, 0.0, rise, 0.0, 0.0);
                this.charAttsList.add(cf);
            }
            if (!emptyBackground) continue;
            Shape shape = text.getOutline(textAt);
            this.width += (int)shape.getBounds2D().getWidth();
            this.width += this.config.getTextSpacing() + 1;
            if (this.height >= (int)shape.getBounds2D().getHeight() + rise) continue;
            this.height = (int)shape.getBounds2D().getHeight() + rise;
        }
        if (emptyBackground) {
            this.image = new BufferedImage(this.width, this.height, 1);
            Graphics2D gfx = (Graphics2D)this.image.getGraphics();
            gfx.setBackground(Color.WHITE);
            gfx.clearRect(0, 0, this.width, this.height);
        }
    }

    private final byte[] render() throws IOException {
        Graphics2D gfx = (Graphics2D)this.image.getGraphics();
        if (this.config.isFontAntialiasing()) {
            gfx.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        }
        int curWidth = this.config.getTextMarginLeft();
        FontRenderContext ctx = new FontRenderContext(null, this.config.isFontAntialiasing(), false);
        for (int i = 0; i < this.charAttsList.size(); ++i) {
            CharAttributes cf = (CharAttributes)this.charAttsList.get(i);
            TextLayout text = new TextLayout(cf.getChar() + "", this.getFont(cf.getName()), ctx);
            AffineTransform textAt = new AffineTransform();
            textAt.translate(curWidth, this.height - cf.getRise());
            if (cf.getRotation() != 0.0) {
                textAt.rotate(cf.getRotation());
            }
            if (cf.getShearX() > 0.0) {
                textAt.shear(cf.getShearX(), cf.getShearY());
            }
            Shape shape = text.getOutline(textAt);
            curWidth = (int)((double)curWidth + (shape.getBounds().getWidth() + (double)this.config.getTextSpacing()));
            if (this.config.isUseImageBackground()) {
                gfx.setColor(Color.BLACK);
            } else {
                gfx.setXORMode(Color.BLACK);
            }
            gfx.fill(shape);
        }
        if (this.config.isEffectsNoise()) {
            this.noiseEffects(gfx, this.image);
        }
        if (this.config.isUseTimestamp()) {
            if (this.config.isEffectsNoise()) {
                gfx.setColor(Color.WHITE);
            } else {
                gfx.setColor(Color.BLACK);
            }
            TimeZone tz = TimeZone.getTimeZone(this.config.getTimestampTZ());
            GregorianCalendar cal = new GregorianCalendar(tz);
            SimpleDateFormat formatter = this.config.isUseTimestamp24hr() ? new SimpleDateFormat("MM/dd/yyyy HH:mm:ss z") : new SimpleDateFormat("MM/dd/yyyy hh:mm:ss a, z");
            formatter.setTimeZone(tz);
            Font font = gfx.getFont();
            Font newFont = new Font(font.getName(), font.getStyle(), this.config.getTimestampFontSize());
            gfx.setFont(newFont);
            gfx.drawString(formatter.format(cal.getTime()), this.config.getTextMarginLeft() * 4, this.height - 1);
        }
        return this.toImageData(this.image);
    }

    protected void noiseEffects(Graphics2D gfx, BufferedImage image) {
        int dx = CaptchaImageResource.randomInt((int)this.width, (int)(2 * this.width));
        int dy = CaptchaImageResource.randomInt((int)this.width, (int)(2 * this.height));
        int x = CaptchaImageResource.randomInt((int)0, (int)(this.width / 2));
        int y = CaptchaImageResource.randomInt((int)0, (int)(this.height / 2));
        gfx.setXORMode(Color.GRAY);
        if (this.config.isFontSizeRandom()) {
            gfx.setStroke(new BasicStroke(CaptchaImageResource.randomInt((int)(this.config.getFontSize() / 8), (int)(this.config.getFontSize() / 2))));
        } else {
            gfx.setStroke(new BasicStroke(this.config.getFontSize()));
        }
        gfx.drawOval(x, y, dx, dy);
        WritableRaster rstr = image.getRaster();
        int[] vColor = new int[3];
        int[] oldColor = new int[3];
        Random vRandom = new Random(System.currentTimeMillis());
        for (x = 0; x < this.width; ++x) {
            for (y = 0; y < this.height; ++y) {
                rstr.getPixel(x, y, oldColor);
                vColor[0] = 0 + (int)(Math.floor((double)vRandom.nextFloat() * 1.03) * 255.0);
                vColor[0] = vColor[0] ^ 170 + (int)(vRandom.nextFloat() * 80.0f);
                vColor[0] = vColor[0] ^ oldColor[0];
                vColor[1] = vColor[0];
                vColor[2] = vColor[0];
                rstr.setPixel(x, y, vColor);
            }
        }
    }

    protected byte[] toImageData(BufferedImage image) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        String format = this.config.getImageFormat().substring(1);
        ImageWriter writer = ImageIO.getImageWritersByFormatName(format).next();
        writer.setOutput(ImageIO.createImageOutputStream(out));
        writer.write(image);
        return out.toByteArray();
    }

    private static int randomInt(int min, int max) {
        return (int)(Math.random() * (double)(max - min) + (double)min);
    }

    public static String randomString(int min, int max) {
        int num = CaptchaImageResource.randomInt((int)min, (int)max);
        byte[] b = new byte[num];
        for (int i = 0; i < num; ++i) {
            b[i] = (byte)CaptchaImageResource.randomInt((int)97, (int)122);
        }
        return new String(b);
    }

    private static String randomWord() {
        String[] words = new String[]{"Albert", "Barber", "Charlie", "Daniel", "Edward", "Flower", "Georgia", "Lawrence", "Michael", "Piper", "Stanley"};
        return words[CaptchaImageResource.randomInt((int)0, (int)words.length)];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        String configLocation = "./WebContent/WEB-INF/mfa.properties";
        String ttsLocation = "./WebContent/WEB-INF/tts.properties";
        PropertiesConfiguration config = new PropertiesConfiguration();
        PropertiesConfiguration tconfig = new PropertiesConfiguration();
        Properties x = new Properties();
        try {
            FileInputStream is = new FileInputStream(configLocation);
            config.load((InputStream)is);
            ((InputStream)is).close();
            FileInputStream tis = new FileInputStream(ttsLocation);
            tconfig.load((InputStream)tis);
            ((InputStream)tis).close();
            MultiFacetedAuthenticationImpl mfa = new MultiFacetedAuthenticationImpl((Configuration)config, (Configuration)tconfig);
            MFA.setInstance((MultiFacetedAuthentication)mfa);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
        CaptchaConfiguration captchaConfig = new CaptchaConfiguration((Configuration)config);
        CaptchaImageResource captcha = new CaptchaImageResource(captchaConfig);
        FileInputStream is = null;
        try {
            is = new FileInputStream("./WebContent/images/jetspeedlogo98.jpg");
            ByteArrayOutputStream bytes = new ByteArrayOutputStream();
            MultiFacetedAuthenticationImpl.drain((InputStream)is, (OutputStream)bytes);
            byte[] background = bytes.toByteArray();
            captcha.setBackgroundImage(background);
        }
        catch (IOException e) {
            captchaConfig.setUseImageBackground(false);
        }
        finally {
            if (is != null) {
                try {
                    ((InputStream)is).close();
                }
                catch (IOException ee) {}
            }
        }
        captcha.init();
        FileOutputStream fs = null;
        try {
            fs = new FileOutputStream("/data/result.jpg");
            byte[] data = captcha.getImageBytes();
            fs.write(data);
        }
        catch (IOException e) {
            logger.error("Unexpected exception during writing captcha image.", (Throwable)e);
        }
        finally {
            try {
                if (fs != null) {
                    fs.close();
                }
            }
            catch (IOException e) {}
        }
    }
}

