/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.security.mfa.impl;

import java.io.InputStream;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.jetspeed.security.mfa.MFA;
import org.apache.jetspeed.security.mfa.MultiFacetedAuthentication;
import org.apache.jetspeed.security.mfa.impl.MultiFacetedAuthenticationImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MFAServletListener
implements ServletContextListener {
    static final Logger logger = LoggerFactory.getLogger(MFAServletListener.class);

    public void contextDestroyed(ServletContextEvent arg0) {
        MultiFacetedAuthentication mfa = MFA.getInstance();
        if (mfa != null) {
            mfa.destroy();
        }
    }

    public void contextInitialized(ServletContextEvent event) {
        String configLocation = "/WEB-INF/mfa.properties";
        String ttsConfigLocation = "/WEB-INF/tts.properties";
        try {
            InputStream is = event.getServletContext().getResourceAsStream(configLocation);
            PropertiesConfiguration config = new PropertiesConfiguration();
            config.load(is);
            is.close();
            InputStream tis = event.getServletContext().getResourceAsStream(ttsConfigLocation);
            PropertiesConfiguration ttsConfig = new PropertiesConfiguration();
            ttsConfig.load(tis);
            tis.close();
            String rootPath = event.getServletContext().getRealPath("/");
            MultiFacetedAuthenticationImpl mfa = new MultiFacetedAuthenticationImpl((Configuration)config, (Configuration)ttsConfig, rootPath);
            MFA.setInstance((MultiFacetedAuthentication)mfa);
        }
        catch (Throwable e) {
            logger.error("Unexpected error during loading configuration.", e);
            PropertiesConfiguration config = new PropertiesConfiguration();
            PropertiesConfiguration ttsConfig = new PropertiesConfiguration();
            MultiFacetedAuthenticationImpl mfa = new MultiFacetedAuthenticationImpl((Configuration)config, (Configuration)ttsConfig);
            MFA.setInstance((MultiFacetedAuthentication)mfa);
        }
    }
}

