/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.security.mfa.impl;

import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jetspeed.security.mfa.CaptchaBean;
import org.apache.jetspeed.security.mfa.MultiFacetedAuthentication;
import org.apache.jetspeed.security.mfa.TextToSpeechBean;
import org.apache.jetspeed.security.mfa.impl.CaptchaBeanImpl;
import org.apache.jetspeed.security.mfa.impl.CaptchaConfiguration;
import org.apache.jetspeed.security.mfa.impl.RemovableResource;
import org.apache.jetspeed.security.mfa.impl.ResourceRemovalCache;
import org.apache.jetspeed.security.mfa.impl.TTSConfiguration;
import org.apache.jetspeed.security.mfa.impl.TextToSpeechBeanImpl;
import org.apache.jetspeed.security.mfa.util.ServerData;

/*
 * Exception performing whole class analysis ignored.
 */
public class MultiFacetedAuthenticationImpl
implements MultiFacetedAuthentication {
    protected static final Log log = LogFactory.getLog(MultiFacetedAuthenticationImpl.class);
    private String captchasRealPath;
    private String ttsRealPath;
    private String backgroundRealPath;
    private String rootPath;
    private CaptchaConfiguration captchaConfig;
    private TTSConfiguration ttsConfig;
    private ResourceRemovalCache removalCache;
    private byte[] background = null;
    static final int BLOCK_SIZE = 4096;

    public MultiFacetedAuthenticationImpl(Configuration cc, Configuration tc) {
        this(cc, tc, null);
    }

    public MultiFacetedAuthenticationImpl(Configuration cc, Configuration tc, String rootPath) {
        this.captchaConfig = new CaptchaConfiguration(cc);
        this.ttsConfig = new TTSConfiguration(tc);
        this.rootPath = rootPath;
        this.captchasRealPath = MultiFacetedAuthenticationImpl.concatenatePaths((String)rootPath, (String)this.captchaConfig.getDirectory());
        this.ttsRealPath = MultiFacetedAuthenticationImpl.concatenatePaths((String)rootPath, (String)this.ttsConfig.getDirectory());
        this.backgroundRealPath = MultiFacetedAuthenticationImpl.concatenatePaths((String)rootPath, (String)this.captchaConfig.getImageBackground());
        if (this.captchaConfig.isUseImageBackground()) {
            this.loadBackground();
        }
        this.removalCache = new ResourceRemovalCache((long)this.captchaConfig.getScanRateSeconds(), (long)this.captchaConfig.getTimetoliveSeconds());
        this.removalCache.setDaemon(true);
        try {
            this.removalCache.start();
        }
        catch (IllegalThreadStateException e) {
            log.error((Object)"Exception starting scanner", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadBackground() {
        FileInputStream is = null;
        try {
            is = new FileInputStream(this.backgroundRealPath);
            ByteArrayOutputStream bytes = new ByteArrayOutputStream();
            MultiFacetedAuthenticationImpl.drain((InputStream)is, (OutputStream)bytes);
            this.background = bytes.toByteArray();
        }
        catch (IOException e) {
            this.captchaConfig.setUseImageBackground(false);
        }
        finally {
            if (is != null) {
                try {
                    ((InputStream)is).close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public void destroy() {
        this.removalCache.shutdown();
    }

    public CaptchaBean createCaptcha(HttpServletRequest request) {
        return this.createCaptcha(request, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CaptchaBean createCaptcha(HttpServletRequest request, String text) {
        CaptchaBeanImpl captcha = text == null ? new CaptchaBeanImpl(this.captchaConfig) : new CaptchaBeanImpl(this.captchaConfig, text);
        if (this.captchaConfig.isUseImageBackground()) {
            captcha.setBackgroundImage(this.background);
        }
        FileOutputStream fs = null;
        ServerData url = new ServerData(request);
        String imageUrl = url.getBasePath() + url.getContextPath() + this.captchaConfig.getDirectory() + "/" + captcha.getImageId() + this.captchaConfig.getImageFormat();
        captcha.setImageURL(imageUrl);
        String imagePath = this.captchasRealPath + "/" + captcha.getImageId() + this.captchaConfig.getImageFormat();
        captcha.init();
        try {
            fs = new FileOutputStream(imagePath);
            byte[] data = captcha.getImageBytes();
            fs.write(data);
            this.removalCache.insert(new RemovableResource(captcha.getImageId(), imagePath));
        }
        catch (IOException e) {
            log.error((Object)"Unexpected error during writing captch image.", (Throwable)e);
            imageUrl = "";
        }
        finally {
            try {
                if (fs != null) {
                    fs.close();
                }
            }
            catch (IOException e) {}
        }
        return captcha;
    }

    public TextToSpeechBean createTextToSpeech(HttpServletRequest request, String text) {
        TextToSpeechBeanImpl tts = new TextToSpeechBeanImpl(text);
        ServerData url = new ServerData(request);
        String audioUrl = url.getBasePath() + url.getContextPath() + this.ttsConfig.getDirectory() + "/" + tts.getAudioId() + this.ttsConfig.getImageFormat();
        tts.setAudioURL(audioUrl);
        this.play((TextToSpeechBean)tts);
        return tts;
    }

    public void play(TextToSpeechBean ttsBean) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void drain(InputStream r, OutputStream w) throws IOException {
        byte[] bytes = new byte[4096];
        try {
            int length = r.read(bytes);
            while (length != -1) {
                if (length != 0) {
                    w.write(bytes, 0, length);
                }
                length = r.read(bytes);
            }
        }
        finally {
            bytes = null;
        }
    }

    private static String concatenatePaths(String root, String rel) {
        if (root == null) {
            return rel;
        }
        if (rel.startsWith("/")) {
            return root + rel.substring(1);
        }
        return root + rel;
    }
}

