/*
 * Decompiled with CFR 0.152.
 */
package org.tp23.antinstaller.renderer.swing;

import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import org.apache.tools.ant.BuildEvent;
import org.tp23.antinstaller.InstallerContext;
import org.tp23.antinstaller.renderer.swing.ProgressPanel;
import org.tp23.antinstaller.runtime.SwingRunner;

public class SwingInstallerContext {
    private static JFrame masterFrame;
    private JLabel feedBackPanel;
    private ProgressPanel progressPanel;
    private InstallerContext ctx;

    public SwingInstallerContext(InstallerContext ctx, JFrame masterFrame) {
        this.ctx = ctx;
        SwingInstallerContext.masterFrame = masterFrame;
    }

    public JFrame getMasterFrame() {
        return masterFrame;
    }

    public SwingRunner getSwingRunner() {
        return (SwingRunner)this.ctx.getRunner();
    }

    public void setFeedBackLabel(JLabel feedBackPanel) {
        this.feedBackPanel = feedBackPanel;
    }

    public void setProgressPanel(ProgressPanel progressPanel) {
        this.progressPanel = progressPanel;
    }

    public void buildStarted(BuildEvent buildEvent) {
        this.provideAntFeedBack(buildEvent.getMessage());
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                public void run() {
                    if (SwingInstallerContext.this.progressPanel != null) {
                        SwingInstallerContext.this.progressPanel.prepareCalledTargets();
                    }
                }
            });
        }
        catch (Exception e) {
            this.ctx.log(e);
        }
    }

    public void buildFinished(BuildEvent buildEvent) {
        if (this.progressPanel != null) {
            try {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        SwingInstallerContext.this.progressPanel.buildFinished();
                    }
                });
            }
            catch (Exception e) {
                this.ctx.log(e);
            }
        }
    }

    public void targetStarted(BuildEvent buildEvent) {
        TargetStarted targetStarted = new TargetStarted();
        targetStarted.buildEvent = buildEvent;
        try {
            if (this.progressPanel != null) {
                SwingUtilities.invokeAndWait(targetStarted);
            }
        }
        catch (Exception e) {
            this.ctx.log(e);
        }
    }

    public void targetFinished(BuildEvent buildEvent) {
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                public void run() {
                    if (SwingInstallerContext.this.progressPanel != null) {
                        SwingInstallerContext.this.progressPanel.targetFinished();
                    }
                }
            });
        }
        catch (Exception e) {
            this.ctx.log(e);
        }
    }

    public void provideAntFeedBack(String message) {
        ProvideAntFeedBack provideAntFeedBack = new ProvideAntFeedBack();
        provideAntFeedBack.message = message;
        try {
            if (this.feedBackPanel != null) {
                SwingUtilities.invokeLater(provideAntFeedBack);
            }
        }
        catch (Exception e) {
            this.ctx.log(e);
        }
    }

    public InstallerContext getInstallerContext() {
        return this.ctx;
    }

    private class ProvideAntFeedBack
    implements Runnable {
        private String message;

        private ProvideAntFeedBack() {
        }

        public void run() {
            SwingInstallerContext.this.feedBackPanel.setText(this.message);
        }
    }

    private class TargetStarted
    implements Runnable {
        private BuildEvent buildEvent;

        private TargetStarted() {
        }

        public void run() {
            SwingInstallerContext.this.progressPanel.targetStarted(this.buildEvent);
        }
    }
}

