/*
 * Decompiled with CFR 0.152.
 */
package org.tp23.antinstaller.antmod;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import org.apache.tools.ant.launch.LaunchException;
import org.apache.tools.ant.launch.Locator;
import org.tp23.antinstaller.InstallerContext;
import org.tp23.antinstaller.antmod.Main;

public class Launcher {
    public static final String ANTHOME_PROPERTY = "ant.home";
    public static final String ANTLIBDIR_PROPERTY = "ant.library.dir";
    public static final String USER_LIBDIR = ".ant/lib";
    public static final String MAIN_CLASS = "org.apache.tools.ant.Main";
    private final Map allProperties;

    public Launcher(Map allProperties) {
        this.allProperties = allProperties;
    }

    public int run(String[] args, InstallerContext cxt) throws LaunchException, MalformedURLException {
        try {
            StringBuffer baseClassPath;
            String antHomeProperty = System.getProperty(ANTHOME_PROPERTY);
            File antHome = null;
            File jarDir = null;
            File sourceJar = Locator.getClassSource(this.getClass());
            jarDir = sourceJar.getParentFile();
            if (antHomeProperty != null) {
                antHome = new File(antHomeProperty);
            }
            if (antHome == null || !antHome.exists()) {
                antHome = jarDir.getParentFile();
                System.setProperty(ANTHOME_PROPERTY, antHome.getAbsolutePath());
            }
            if (!antHome.exists()) {
                throw new LaunchException("Ant home is set incorrectly or ant could not be located");
            }
            ArrayList<String> libPaths = new ArrayList<String>();
            ArrayList<String> argList = new ArrayList<String>();
            for (int i = 0; i < args.length; ++i) {
                if (args[i].equals("-lib")) {
                    if (i == args.length - 1) {
                        throw new LaunchException("The -lib argument must be followed by a library location");
                    }
                    libPaths.add(args[++i]);
                    continue;
                }
                argList.add(args[i]);
            }
            String[] newArgs = libPaths.size() == 0 ? args : argList.toArray(new String[0]);
            ArrayList<URL> libPathURLs = new ArrayList<URL>();
            Iterator i = libPaths.iterator();
            while (i.hasNext()) {
                String libPath = (String)i.next();
                StringTokenizer myTokenizer = new StringTokenizer(libPath, System.getProperty("path.separator"));
                while (myTokenizer.hasMoreElements()) {
                    String elementName = myTokenizer.nextToken();
                    File element = new File(elementName);
                    if (elementName.indexOf("%") != -1 && !element.exists()) continue;
                    if (element.isDirectory()) {
                        URL[] dirURLs = Locator.getLocationURLs(element);
                        for (int j = 0; j < dirURLs.length; ++j) {
                            libPathURLs.add(dirURLs[j]);
                        }
                    }
                    libPathURLs.add(element.toURL());
                }
            }
            URL[] libJars = libPathURLs.toArray(new URL[0]);
            File toolsJar = Locator.getToolsJar();
            File antLibDir = null;
            String antLibDirProperty = System.getProperty(ANTLIBDIR_PROPERTY);
            if (antLibDirProperty != null) {
                antLibDir = new File(antLibDirProperty);
            }
            if (antLibDir == null || !antLibDir.exists()) {
                antLibDir = jarDir;
                System.setProperty(ANTLIBDIR_PROPERTY, antLibDir.getAbsolutePath());
            }
            URL[] systemJars = Locator.getLocationURLs(antLibDir);
            File userLibDir = new File(System.getProperty("user.home"), USER_LIBDIR);
            URL[] userJars = Locator.getLocationURLs(userLibDir);
            int numJars = libJars.length + userJars.length + systemJars.length;
            if (toolsJar != null) {
                ++numJars;
            }
            URL[] jars = new URL[numJars];
            System.arraycopy(libJars, 0, jars, 0, libJars.length);
            System.arraycopy(userJars, 0, jars, libJars.length, userJars.length);
            System.arraycopy(systemJars, 0, jars, userJars.length + libJars.length, systemJars.length);
            if (toolsJar != null) {
                jars[jars.length - 1] = toolsJar.toURL();
            }
            if ((baseClassPath = new StringBuffer(System.getProperty("java.class.path"))).charAt(baseClassPath.length() - 1) == File.pathSeparatorChar) {
                baseClassPath.setLength(baseClassPath.length() - 1);
            }
            for (int i2 = 0; i2 < jars.length; ++i2) {
                baseClassPath.append(File.pathSeparatorChar);
                baseClassPath.append(Locator.fromURI(jars[i2].toString()));
            }
            System.setProperty("java.class.path", baseClassPath.toString());
            URLClassLoader loader = new URLClassLoader(jars);
            Thread.currentThread().setContextClassLoader(loader);
            try {
                Main main = new Main();
                Properties props = new Properties();
                props.putAll((Map<?, ?>)this.allProperties);
                return main.startAnt(newArgs, props, null, cxt);
            }
            catch (Throwable t) {
                t.printStackTrace();
                return 1;
            }
        }
        catch (Throwable ex) {
            try {
                System.setProperty(ANTHOME_PROPERTY, new File(".").getAbsolutePath());
                Main main = new Main();
                String[] newArgs = new String[args.length - 2];
                int n = 0;
                for (int i = 0; i < args.length; ++i) {
                    if (args[i].equals("-lib")) {
                        ++i;
                        continue;
                    }
                    newArgs[n++] = args[i];
                }
                Properties props = new Properties();
                props.putAll((Map<?, ?>)this.allProperties);
                return main.startAnt(newArgs, props, null, cxt);
            }
            catch (Throwable t) {
                t.printStackTrace();
                return 1;
            }
        }
    }
}

