/*
 * Decompiled with CFR 0.152.
 */
package org.tp23.antinstaller.renderer.text;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ResourceBundle;
import org.tp23.antinstaller.InstallerContext;
import org.tp23.antinstaller.input.OutputField;
import org.tp23.antinstaller.input.ValidatedTextInput;
import org.tp23.antinstaller.renderer.text.TextOutputFieldRenderer;

public class ValidatedTextInputRenderer
implements TextOutputFieldRenderer {
    private static final ResourceBundle res = ResourceBundle.getBundle("org.tp23.antinstaller.renderer.text.Res");
    protected InstallerContext ctx;

    public void setContext(InstallerContext ctx) {
        this.ctx = ctx;
    }

    public void renderOutput(OutputField field, BufferedReader reader, PrintStream out) throws IOException {
        ValidatedTextInput iField = (ValidatedTextInput)field;
        out.print(field.getDisplayText());
        out.print("   [");
        out.print(res.getString("_default_"));
        out.print(":");
        out.print(iField.getDefaultValue());
        out.println("]");
        String input = reader.readLine();
        out.println();
        if (input == null || input.equals("")) {
            input = iField.getDefaultValue();
        }
        iField.setInputResult(input);
    }

    public void renderError(OutputField field, BufferedReader reader, PrintStream out) throws IOException {
        out.println("The input is not of the correct format");
        this.renderOutput(field, reader, out);
    }

    public boolean isAbort() {
        return false;
    }
}

