/*
 * Decompiled with CFR 0.152.
 */
package org.tp23.antinstaller.renderer.swing;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagLayout;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.tp23.antinstaller.ValidationException;
import org.tp23.antinstaller.input.CommentOutput;
import org.tp23.antinstaller.input.OutputField;
import org.tp23.antinstaller.page.SimpleInputPage;
import org.tp23.antinstaller.renderer.RendererFactory;
import org.tp23.antinstaller.renderer.swing.CommentOutputRenderer;
import org.tp23.antinstaller.renderer.swing.DisplayTextArea;
import org.tp23.antinstaller.renderer.swing.SizeConstants;
import org.tp23.antinstaller.renderer.swing.SwingOutputFieldRenderer;
import org.tp23.antinstaller.renderer.swing.SwingPageRenderer;
import org.tp23.gui.GBCF;

public class SimpleInputPageRenderer
extends SwingPageRenderer {
    private static final Font defaultFont = new JLabel().getFont();
    private JPanel contentPanel = new JPanel();
    private GridBagLayout gridLayout = new GridBagLayout();
    private GBCF cf = new GBCF();
    private boolean overflow = false;
    JScrollPane scroller = null;
    private ArrayList renderers = new ArrayList();

    public boolean validateFields() throws ValidationException {
        OutputField[] fields = this.page.getOutputField();
        for (int i = 0; i < fields.length; ++i) {
            if (fields[i].validate(this.ctx)) continue;
            SwingOutputFieldRenderer renderer = (SwingOutputFieldRenderer)this.renderers.get(i);
            renderer.renderError();
            return false;
        }
        return true;
    }

    public void updateInputFields() {
        for (int i = 0; i < this.renderers.size(); ++i) {
            ((SwingOutputFieldRenderer)this.renderers.get(i)).updateInputField();
        }
    }

    public void updateDefaultValues() {
        for (int i = 0; i < this.renderers.size(); ++i) {
            ((SwingOutputFieldRenderer)this.renderers.get(i)).updateDefaultValue();
        }
    }

    public void instanceInit() throws Exception {
        this.overflow = ((SimpleInputPage)this.page).isOverflow();
        if (this.overflow) {
            this.contentPanel.setMaximumSize(new Dimension(SizeConstants.PAGE_WIDTH - 50, SizeConstants.PAGE_HEIGHT));
            this.scroller = new JScrollPane();
            this.scroller.setHorizontalScrollBarPolicy(30);
            this.scroller.setVerticalScrollBarPolicy(20);
            this.scroller.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4), BorderFactory.createEtchedBorder()));
            this.add((Component)this.scroller, "Center");
            this.scroller.getViewport().add(this.contentPanel);
        } else {
            this.add((Component)this.contentPanel, "Center");
            this.contentPanel.setBorder(BorderFactory.createEmptyBorder(SizeConstants.TOP_INDENT, 4, 4, 4));
        }
        OutputField[] fields = this.page.getOutputField();
        this.contentPanel.setDoubleBuffered(true);
        this.contentPanel.setLayout(this.gridLayout);
        int row = 0;
        for (int i = 0; i < fields.length; ++i) {
            SwingOutputFieldRenderer renderer = RendererFactory.getSwingRenderer(fields[i]);
            String text = fields[i].getExplanatoryText();
            if (fields[i].getExplanatoryText() != null) {
                DisplayTextArea area = new DisplayTextArea(this.contentPanel.getBackground(), this.contentPanel.getForeground());
                area.setIgnoreRepaint(true);
                area.setFont(defaultFont);
                area.setText(text);
                this.contentPanel.add((Component)area, this.cf.getSpan(row++));
                if (fields[i] instanceof CommentOutput) {
                    CommentOutputRenderer crenderer = (CommentOutputRenderer)renderer;
                    crenderer.setExplanatoryTextField(area);
                    if (fields[i].getDisplayText() == null) continue;
                }
            }
            renderer.setOutputField(fields[i]);
            renderer.setInstallerContext(this.ctx);
            renderer.initComponent(this.contentPanel);
            row = renderer.addSelf(this.contentPanel, this.cf, row, this.overflow);
            this.renderers.add(renderer);
        }
        this.contentPanel.add((Component)new JPanel(), this.cf.getVertGlue(row++));
    }
}

