/*
 * Decompiled with CFR 0.152.
 */
package org.tp23.antinstaller.runtime;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import org.tp23.antinstaller.InstallException;
import org.tp23.antinstaller.Installer;
import org.tp23.antinstaller.input.ConditionalField;
import org.tp23.antinstaller.input.InputField;
import org.tp23.antinstaller.input.OutputField;
import org.tp23.antinstaller.input.ResultContainer;
import org.tp23.antinstaller.input.SelectInput;
import org.tp23.antinstaller.input.TargetInput;
import org.tp23.antinstaller.input.TargetSelectInput;
import org.tp23.antinstaller.page.Page;
import org.tp23.antinstaller.page.ProgressPage;
import org.tp23.antinstaller.page.SimpleInputPage;
import org.tp23.antinstaller.runtime.ConfigurationException;
import org.tp23.antinstaller.runtime.VersionHelper;
import org.tp23.antinstaller.runtime.exe.LoadConfigFilter;
import org.tp23.antinstaller.runtime.logic.ExpressionBuilder;

public class ConfigurationLoader
extends LoadConfigFilter {
    public static void main(String[] args) {
        ConfigurationLoader configurationLoader = new ConfigurationLoader();
        String configFile = "antinstall-config.xml";
        if (args.length > 1 && args[1].endsWith(".xml")) {
            configFile = args[1];
        }
        int ret = 1;
        try {
            configurationLoader.readConfig(new File(args[0]), configFile);
            ret = configurationLoader.validate();
            if (ret > 0) {
                System.out.println("VALIDATION FAILED");
            }
        }
        catch (ConfigurationException ex) {
            ex.printStackTrace();
            System.exit(ret);
        }
        catch (IOException ex) {
            ex.printStackTrace();
            System.exit(ret);
        }
        catch (InstallException ex) {
            ex.printStackTrace();
            System.exit(ret);
        }
    }

    public Installer getInstaller() {
        return this.installer;
    }

    public int validate() throws IOException, ConfigurationException, InstallException {
        Page[] pages = this.installer.getPages();
        boolean foundErrors = false;
        HashSet<String> pageNames = new HashSet<String>();
        HashSet<String> targets = new HashSet<String>();
        HashSet<String> propertyNames = new HashSet<String>();
        HashSet<String> pagePropertyNames = null;
        if (this.validateInstallerAttributes()) {
            foundErrors = true;
        }
        for (int p = 0; p < pages.length; ++p) {
            SimpleInputPage sPage;
            System.out.println("Checking page: " + pages[p].getName());
            if (pageNames.contains(pages[p].getName())) {
                System.out.println("Error: page name '" + pages[p].getName() + "' repeated - auto loading of configuration will fail");
                foundErrors = true;
            }
            pageNames.add(pages[p].getName());
            if (pages[p] instanceof SimpleInputPage && (sPage = (SimpleInputPage)pages[p]).getIfProperty() != null) {
                try {
                    ResultContainer mock = new ResultContainer();
                    ExpressionBuilder.parseLogicalExpressions(mock, sPage.getIfProperty());
                }
                catch (ConfigurationException configExc) {
                    System.out.println("Error: loading ifProperty," + sPage.getIfProperty() + " ,page: " + pages[p].getName());
                    foundErrors = true;
                }
            }
            pagePropertyNames = new HashSet<String>();
            OutputField[] fields = pages[p].getOutputField();
            for (int f = 0; f < fields.length; ++f) {
                String propertyName;
                if (!fields[f].validateObject()) {
                    foundErrors = true;
                    System.out.println("Error in page:" + pages[p].getName());
                }
                if (fields[f] instanceof TargetInput) {
                    TargetInput tgtInput = (TargetInput)fields[f];
                    targets.add(tgtInput.getTarget());
                }
                if (!(fields[f] instanceof InputField) || fields[f] instanceof ConditionalField) continue;
                InputField genericInput = (InputField)fields[f];
                if (genericInput.getProperty().endsWith("-targets")) {
                    System.out.println("Error: invalid property name:" + genericInput.getProperty());
                    System.out.println("InputField names must not end with -targets");
                }
                if (propertyNames.contains(propertyName = genericInput.getProperty())) {
                    System.out.println("Repeated property name:" + propertyName);
                    System.out.println("Loading defaults from file will probably not work:" + propertyName);
                } else {
                    propertyNames.add(propertyName);
                }
                if (pagePropertyNames.contains(propertyName)) {
                    foundErrors = true;
                    System.out.println("Repeated property name: page=" + pages[p].getName() + ", property=" + propertyName);
                    continue;
                }
                pagePropertyNames.add(propertyName);
            }
        }
        System.out.println("Finished checking config inputs");
        if (!(pages[pages.length - 1] instanceof ProgressPage)) {
            foundErrors = true;
            System.out.println("Last Page should be a progress page");
        } else if (pages[pages.length - 1].getPostDisplayTarget() != null) {
            foundErrors = true;
            System.out.println("Progress pages do not support postDisplayTarget");
        }
        int numOfPageTargets = 0;
        for (int p = 0; p < pages.length; ++p) {
            numOfPageTargets += pages[p].getAllTargets().size();
        }
        if (numOfPageTargets == 0) {
            System.out.println("Warning: No Page Targets (not a problem if there are target input types)");
        }
        Iterator iter = targets.iterator();
        while (iter.hasNext()) {
            String tgt = (String)iter.next();
            if (!tgt.endsWith("-targets")) continue;
            System.out.println("Error: invalid target name:" + tgt);
            System.out.println("Target names must not end with -targets");
            foundErrors = true;
        }
        int numOfTargetInputs = 0;
        ArrayList<String> targetsSoFar = new ArrayList<String>();
        for (int p = 0; p < pages.length; ++p) {
            SimpleInputPage simple;
            String ifTarget;
            if (pages[p] instanceof SimpleInputPage && (ifTarget = (simple = (SimpleInputPage)pages[p]).getIfTarget()) != null && !targetsSoFar.contains(ifTarget)) {
                System.out.println("ifTarget=" + ifTarget);
                System.out.println("ifTarget will never test true, no prior target in page:" + pages[p].getName());
            }
            targetsSoFar.addAll(pages[p].getAllTargets());
            OutputField[] fields = pages[p].getOutputField();
            for (int f = 0; f < fields.length; ++f) {
                InputField ti;
                if (fields[f] instanceof TargetInput) {
                    if (numOfTargetInputs == 0) {
                        System.out.println("Found target input type");
                    }
                    ++numOfTargetInputs;
                    ti = (TargetInput)fields[f];
                    targetsSoFar.add(((TargetInput)ti).getTarget());
                }
                if (!(fields[f] instanceof TargetSelectInput)) continue;
                if (numOfTargetInputs == 0) {
                    System.out.println("Found target input type");
                }
                ++numOfTargetInputs;
                ti = (TargetSelectInput)fields[f];
                SelectInput.Option[] options = ((SelectInput)ti).getOptions();
                for (int i = 0; i < options.length; ++i) {
                    SelectInput.Option option = options[i];
                    targetsSoFar.add(option.value);
                }
            }
        }
        if (numOfPageTargets == 0 && numOfTargetInputs == 0) {
            System.out.println("Warning: No targets found, installer may do nothing.");
        }
        System.out.println("Finished checking config");
        if (!foundErrors) {
            return 0;
        }
        return 1;
    }

    private boolean validateInstallerAttributes() {
        System.out.println("Checking installer: " + this.installer.getName());
        boolean foundErrors = false;
        String[] validBooleanValues = new String[]{"true", "false"};
        foundErrors |= this.validateValue("antialiased", this.installer.getAntialiased(), true, validBooleanValues);
        String[] validLAFValues = new String[]{"org.tp23.jgoodies.plaf.plastic.PlasticXPLookAndFeel", "greymetal", "native", "jgoodies", "null"};
        if (this.validateValue("lookAndFeel", this.installer.getLookAndFeel(), true, validLAFValues)) {
            System.out.println("Warning: non standard LookAndFeel ensure the correct classes are on the classpath at runtime:" + this.installer.getLookAndFeel());
        }
        if (this.installer.getName() == null) {
            System.out.println("Error: installer element attribute does not exist: name");
            foundErrors = true;
        }
        try {
            String wide = this.installer.getWide();
            if (wide != null) {
                this.installer.parseWideValue(wide);
            }
        }
        catch (Exception e) {
            System.out.println("Error: installer element attribute incorrect format (e.g. 600:275): wide");
            foundErrors = true;
        }
        String[] validLoadDefaultValues = new String[]{"false", "true", "prompt", "prompt-auto"};
        boolean loadDefaultsNull = true;
        if (this.installer.supportsAutoBuild()) {
            loadDefaultsNull = false;
        }
        foundErrors |= this.validateValue("loadDefaults", this.installer.getLoadDefaults(), loadDefaultsNull, validLoadDefaultValues);
        VersionHelper vHelper = new VersionHelper();
        if (this.installer.supportsAutoBuild() && !vHelper.isValid(this.installer.getVersion())) {
            System.out.println("Error: invalid version attribute, required for -auto builds:" + this.installer.getVersion());
            foundErrors = true;
        }
        if (this.installer.getVersion() != null && !vHelper.isValid(this.installer.getVersion())) {
            System.out.println("Error: invalid version attribute format examples 1.2.0 , 0.2beta:" + this.installer.getVersion());
            foundErrors = true;
        }
        return foundErrors;
    }

    private boolean validateValue(String att, String value, boolean allowsNull, String[] validValues) {
        if (value == null) {
            if (!allowsNull) {
                System.out.println("Error: installer element attribute does not exist: " + att);
                return true;
            }
            return false;
        }
        for (int i = 0; i < validValues.length; ++i) {
            if (!validValues[i].equals(value)) continue;
            return false;
        }
        System.out.println("Error: installer element attribute not valid value: " + att);
        return true;
    }
}

