package org.apache.jetspeed.portletcontainer;


import java.io.ObjectStreamClass;
import java.io.IOException;

public class PortletAppObjectInputStream extends java.io.ObjectInputStream {
    private ClassLoader classloader_ = null;

/**
 * PortletAppObjectInputStream constructor comment.
 * @exception java.io.IOException The exception description.
 * @exception java.lang.SecurityException The exception description.
 */
    protected PortletAppObjectInputStream() throws java.io.IOException, SecurityException {
        super();
    }
/**
 * PortletAppObjectInputStream constructor comment.
 * @param in java.io.InputStream
 * @exception java.io.IOException The exception description.
 * @exception java.io.StreamCorruptedException The exception description.
 */
    public PortletAppObjectInputStream(java.io.InputStream in) throws java.io.IOException, java.io.StreamCorruptedException {
        super(in);
    }
    /**
 * Load the local class equivalent of the specified stream class description.
 *
 * Subclasses may implement this method to allow classes to be
 * fetched from an alternate source. 
 *
 * The corresponding method in ObjectOutputStream is
 * annotateClass.  This method will be invoked only once for each
 * unique class in the stream.  This method can be implemented by
 * subclasses to use an alternate loading mechanism but must
 * return a Class object.  Once returned, the serialVersionUID of the
 * class is compared to the serialVersionUID of the serialized class.
 * If there is a mismatch, the deserialization fails and an exception
 * is raised. <p>
 *
 * By default the class name is resolved relative to the class
 * that called readObject. <p>
 *
 * @exception ClassNotFoundException If class of
 * a serialized object cannot be found.
 */
    protected Class resolveClass(ObjectStreamClass v)
    throws IOException, ClassNotFoundException
    {
        /* Resolve by looking up the stack for a non-zero class
         * loader. If not found use the system class loader.
         */
        return classloader_.loadClass(v.getName());
    }
    public void setClassLoader(ClassLoader classloader) {
        classloader_ = classloader;
    }
}
