package org.apache.jetspeed.portlet;

import java.util.Enumeration;

/**
 ** The <CODE>Client</CODE> interface represents the client device that
 ** the user connects to the portal with. It defines methods to obtain
 ** information about clients, e.g. browsers running on PCs, WAP phones,
 ** PDAs or on voice gateways.
 **
 ** <P>
 ** <I>
 ** This class may need to be reviewed once the picture on CC/PP is
 ** much clearer.
 ** </I>
 **
 ** @author   <A HREF="mailto:tboehme@apache.org">Thomas F. Boehme</A>
 **/

public interface Client
{
    /**
     ** Returns the name of the manufacturer of this client, or
     ** <CODE>null</CODE> if the name is not available.
     **
     ** @return   the manufacturer
     **/

    public String getManufacturer ();

    /**
     ** Returns the name of the model of this client, or
     ** <CODE>null</CODE> if the name is not available.
     **
     ** @return   the model
     **/

    public String getModel ();

    /**
     ** Returns the version of the model of this client, or
     ** <CODE>null</CODE> if the version is not available.
     **
     ** @return   the version
     **/

    public String getVersion ();

    /**
     ** Returns the exact user agent that this client uses
     ** to identify itself to the portal. If the client does
     ** not send a user agent, this method returns
     ** <CODE>null</CODE>.
     **
     ** @return   the user agent
     **/

    public String getUserAgent ();

    /**
     ** Returns whether this client has the given capability. If the
     ** portal does not know enough about the client, it has to be
     ** on the safe side and return <CODE>false</CODE>.
     **
     ** @return   <CODE>true</CODE> if the client has the given
     **                             capability, <BR>
     **           <CODE>false</CODE> otherwise
     **
     ** @see   #isCapableOf(Capability[])
     **/

    public boolean isCapableOf (Capability capability);


    /**
     ** Returns whether this client has the given capabilities. The
     ** array of capability is tested in its entirety, ie. only if
     ** the client is capable of every single capability this methods
     ** returns <CODE>true<CODE>.
     **
     ** @return   <CODE>true</CODE> if the client has the given
     **                             capability, <BR>
     **           <CODE>false</CODE> otherwise
     **
     ** @see   #isCapableOf(Capability)
     **/

    public boolean isCapableOf (Capability [] capabilities);

    /**
     ** Returns the preferred mime-type that this client device supports.
     **
     ** @return   the mime-type
     **/

    public String getMimeType ();

    /**
     ** Returns the preferred markup name that this client device supports.
     **
     ** @return   the naem of the markup
     **/

    public String getMarkupName ();

}
