package org.apache.jetspeed.portletcontainer.event;

// jetspeed
import org.apache.jetspeed.portlet.*;
import org.apache.jetspeed.portlet.event.*;

import org.apache.jetspeed.portletcontainer.event.*;
import org.apache.jetspeed.portletcontainer.om.portletregistry.ConcretePortletEntry;
import org.apache.jetspeed.portletcontainer.om.applicationregistry.ConcreteApplicationEntry;
import org.apache.jetspeed.portletcontainer.information.PortalInformationProvider;
import org.apache.jetspeed.portletcontainer.invoker.PortletInvokerException;

import com.ibm.wps.portletcontainer.invoker.*;

// turbine
import org.apache.turbine.util.Log;

// java
import javax.servlet.*;
import javax.servlet.http.*;
import java.io.*;
import java.util.*;

public class EventBroker
{

    public static void preparePortletSettingsAdded(HttpServletRequest servletRequest,
                                                   ConcretePortletEntry concretePortlet,
                                                   PortalInformationProvider provider,
                                                   Map settings)
    {
        enqueuePortletSettings(servletRequest,
                               concretePortlet,
                               provider,
                               PortletSettingsAttributeEventImpl.SETTING_ADDED,
                               settings);
    }

    public static void preparePortletSettingsReplaced(HttpServletRequest servletRequest,
                                                      ConcretePortletEntry concretePortlet,
                                                      PortalInformationProvider provider,
                                                      Map settings)
    {
        enqueuePortletSettings(servletRequest,
                               concretePortlet,
                               provider,
                               PortletSettingsAttributeEventImpl.SETTING_REPLACED,
                               settings);
    }

    public static void preparePortletSettingsRemoved(HttpServletRequest servletRequest,
                                                     ConcretePortletEntry concretePortlet,
                                                     PortalInformationProvider provider,
                                                     Map settings)
    {
        enqueuePortletSettings(servletRequest,
                               concretePortlet,
                               provider,
                               PortletSettingsAttributeEventImpl.SETTING_REMOVED,
                               settings);
    }

    public static void processPortletSettingsEventLoop(ConcretePortletEntry concretePortlet,
                                                       EventEnvironment evtEnv)
    throws PortletException,PortletInvokerException
    {
        processSettingsEventLoop(org.apache.jetspeed.portlet.spi.Constants.METHOD_PORTLET_SETTINGS_EVENT,
                                 concretePortlet,
                                 evtEnv);
    }

    public static void preparePortletApplicationSettingsAdded(HttpServletRequest servletRequest,
                                                              ConcretePortletEntry concretePortlet,
                                                              PortalInformationProvider provider,
                                                              Map settings)
    {
        enqueuePortletApplicationSettings(servletRequest,
                                          concretePortlet,
                                          provider,
                                          PortletSettingsAttributeEventImpl.SETTING_ADDED,
                                          settings);
    }

    public static void preparePortletApplicationSettingsReplaced(HttpServletRequest servletRequest,
                                                                 ConcretePortletEntry concretePortlet,
                                                                 PortalInformationProvider provider,
                                                                 Map settings)
    {
        enqueuePortletApplicationSettings(servletRequest,
                                          concretePortlet,
                                          provider,
                                          PortletSettingsAttributeEventImpl.SETTING_REPLACED,
                                          settings);
    }

    public static void preparePortletApplicationSettingsRemoved(HttpServletRequest servletRequest,
                                                                ConcretePortletEntry concretePortlet,
                                                                PortalInformationProvider provider,
                                                                Map settings)
    {
        enqueuePortletApplicationSettings(servletRequest,
                                          concretePortlet,
                                          provider,
                                          PortletSettingsAttributeEventImpl.SETTING_REMOVED,
                                          settings);
    }

    public static void processPortletApplicationSettingsEventLoop(ConcretePortletEntry concretePortlet,
                                                                  EventEnvironment evtEnv)
    throws PortletException,PortletInvokerException
    {
        processSettingsEventLoop(org.apache.jetspeed.portlet.spi.Constants.METHOD_PORTLETAPPLICATION_SETTINGS_EVENT,
                                 concretePortlet,
                                 evtEnv);
    }

    // private methods

    private static void enqueuePortletSettings(HttpServletRequest servletRequest,
                                               ConcretePortletEntry concretePortlet,
                                               PortalInformationProvider provider,
                                               int type,
                                               Map settings)
    {
        Iterator iterator = settings.keySet().iterator();
        while (iterator.hasNext())
        {
            String key = (String)iterator.next();
            String value = (String)settings.get(key);

            PortletSettingsAttributeEventImpl event =
                new PortletSettingsAttributeEventImpl(type,
                                                      concretePortlet,
                                                      provider,
                                                      key,
                                                      value);

            getEventQueue(servletRequest).add(event);
        }
    }

    private static void enqueuePortletApplicationSettings(HttpServletRequest servletRequest,
                                                          ConcretePortletEntry concretePortlet,
                                                          PortalInformationProvider provider,
                                                          int type,
                                                          Map settings)
    {
        Iterator iterator = settings.keySet().iterator();
        while (iterator.hasNext())
        {
            String key = (String)iterator.next();
            String value = (String)settings.get(key);

            PortletApplicationSettingsAttributeEventImpl event =
                new PortletApplicationSettingsAttributeEventImpl(type,
                                                                 concretePortlet,
                                                                 provider,
                                                                 key,
                                                                 value);

            getEventQueue(servletRequest).add(event);
        }
    }

    private static void processSettingsEventLoop(int method,
                                                 ConcretePortletEntry concretePortlet,
                                                 EventEnvironment evtEnv)
    throws PortletException,PortletInvokerException
    {
        if (Log.isDebugEnabled)
            Log.debug( "EventBroker.processSettingsEventLoop: sending all events to target portlet...");

        PortletInvokerImpl invoker = (PortletInvokerImpl)evtEnv.getPortletInvoker();

        HttpServletRequest servletRequest = evtEnv.getServletRequest();
        
        HttpServletResponse servletResponse = evtEnv.getServletResponse();

        PortletInvokerImpl.InternalPortletData data = 
            ((PortletInvokerImpl.EventEnvironmentImpl)evtEnv).getInternalPortletData(concretePortlet);

        try
        {
            servletRequest.setAttribute(org.apache.jetspeed.portlet.spi.Constants.PARAM_SETTINGS_EVENT,
                                        getEventQueue(servletRequest));
            // include portlet by using request dispatcher
            invoker.include (method,
                             servletRequest, 
                             servletResponse, 
                             data,
                             false);
        }
        catch (PortletException e)
        {
            String message = "EventBroker.processSettingsEventLoop: The portlet ("+concretePortlet+") failed while processing settings attribute event.";
            Log.error(message, e);
            throw e; // rethrow
        }
        catch (IOException e)
        {
            String message = "EventBroker.processSettingsEventLoop: The portlet ("+concretePortlet+") failed while processing settings attribute event.";
            Log.error(message, e);
            throw new PortletException(e); // rethrow
        }
        finally
        {
            clearEventQueue(servletRequest);
        }
    }

    private static Vector getEventQueue(ServletRequest servletRequest)
    {
        Vector queue = (Vector)servletRequest.getAttribute("PC_SettingsEventQueue");
        if (queue==null) {
            queue = new Vector();
            servletRequest.setAttribute("PC_SettingsEventQueue", queue);
        }
        return queue;
    }

    private static void clearEventQueue(ServletRequest servletRequest)
    {
        servletRequest.removeAttribute("PC_SettingsEventQueue");
    }

}
