/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.jetspeed.security.impl;

import org.apache.jetspeed.security.JetspeedPrincipalAssociationType;
import org.apache.jetspeed.security.JetspeedPrincipalType;

/**
 * @version $Id: JetspeedPrincipalAssociationTypeImpl.java 698741 2008-09-24 21:22:18Z ate $
 */
public class JetspeedPrincipalAssociationTypeImpl implements JetspeedPrincipalAssociationType
{
    private String associationName;
    private JetspeedPrincipalType fromType;
    private JetspeedPrincipalType toType;
    private boolean required;
    private boolean dependent;
    private boolean singular;
    private boolean dominant;
    private boolean mixedTypes;
    
    public JetspeedPrincipalAssociationTypeImpl(String associationName, JetspeedPrincipalType fromType,
                                                JetspeedPrincipalType toType, boolean required, boolean dependent, boolean singular, boolean dominant)
    {
        this.associationName = associationName;
        this.fromType = fromType;
        this.toType = toType;
        this.required = required;
        this.dependent = dependent;
        this.singular = singular;
        this.dominant = dominant;
        this.mixedTypes = !fromType.getName().equals(toType.getName());
    }

    public String getAssociationName()
    {
        return associationName;
    }

    public JetspeedPrincipalType getFromPrincipalType()
    {
        return fromType;
    }

    public JetspeedPrincipalType getToPrincipalType()
    {
        return toType;
    }

    public boolean isRequired()
    {
        return required;
    }

    public boolean isDependent()
    {
        return dependent;
    }

    public boolean isSingular()
    {
        return singular;
    }

    public boolean isDominant()
    {
        return dominant;
    }
    
    public boolean isMixedTypes()
    {
        return mixedTypes;
    }
}
