/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.jetspeed.security.spi.impl.cache;

import net.sf.ehcache.Element;

import java.io.Serializable;

/**
 * JSPMQueryCacheElement - JetspeedSecurityPersistenceManager query cache Element
 *
 * @author <a href="mailto:rwatler@apache.org">Randy Watler</a>
 * @version $Id: $
 */
public class JSPMQueryCacheElement extends Element
{
    /**
     * Cache element wildcard dependent id.
     */
    public static final long ANY_ID = 0L;

    private static final long serialVersionUID = 1L;

    // dependent instance ids
    private long [] principalIds;
    private long [] permissionIds;
    private long [] domainIds;

    /**
     * Construct new cache element.
     *
     * @param key cache element key
     * @param value cache element value
     */
    public JSPMQueryCacheElement(Serializable key, Serializable value)
    {
        super(key, value);
    }

    /**
     * Construct new cache element.
     *
     * @param key cache element key
     * @param value cache element value
     */
    public JSPMQueryCacheElement(Serializable key, Object value)
    {
        super(key, value);
    }

    public long [] getPrincipalIds()
    {
        return principalIds;
    }

    public void setPrincipalIds(long [] principalIds)
    {
        this.principalIds = principalIds;
    }

    public long [] getPermissionIds()
    {
        return permissionIds;
    }

    public void setPermissionIds(long [] permissionIds)
    {
        this.permissionIds = permissionIds;
    }

    public long [] getDomainIds()
    {
        return domainIds;
    }

    public void setDomainIds(long [] domainIds)
    {
        this.domainIds = domainIds;
    }
}
